/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.funpackage;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.FunPackageGateway;
import com.cicv.foton.admin.domain.system.FunPackage;
import com.cicv.foton.admin.domain.system.FunPackagePermRel;
import com.cicv.foton.admin.dto.FunPackageCmd;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FunPackageUpdateFunPackageCmdExe {
    @Autowired
    private FunPackageGateway funPackageGateway;

    public void execute(FunPackageCmd funPackageCmd) {
        Long id = funPackageCmd.getId();
        String name = funPackageCmd.getName();
        Long parentId = funPackageCmd.getParentId();
        List permIds = funPackageCmd.getPermIds();
        if (Objects.isNull(id) || StringUtils.isBlank((String)name) || Objects.isNull(permIds) || permIds.isEmpty()) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        List selectList = this.funPackageGateway.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FunPackage::getName, (Object)name)).notIn(FunPackage::getParentId, new Object[]{parentId}));
        if (!selectList.isEmpty()) {
            throw new BaseBusinessException(CommonEnum.PACKAGE_NAME_IS_USED.getCode(), CommonEnum.PACKAGE_NAME_IS_USED.getMessage());
        }
        FunPackage funPackage = this.funPackageGateway.selectById(id);
        if (Objects.isNull(funPackage)) {
            throw new BaseBusinessException(CommonEnum.PACKAGE_IS_ABSENT.getCode(), CommonEnum.PACKAGE_IS_ABSENT.getMessage());
        }
        String ver = funPackage.getVer();
        Long hisVer = funPackage.getHisVer();
        Long pid = funPackage.getParentId();
        funPackage = new FunPackage();
        BeanUtil.copyProperties((Object)funPackageCmd, (Object)funPackage, (String[])new String[0]);
        funPackage.setParentId(pid);
        funPackage.setVer(this.getNewVersion(ver));
        funPackage.setHisVer(Long.valueOf(hisVer + 1L));
        funPackage.setId(null);
        this.funPackageGateway.insert(funPackage);
        for (Long permId : permIds) {
            FunPackagePermRel funPackagePermRel = new FunPackagePermRel();
            funPackagePermRel.setPkgId(funPackage.getId());
            funPackagePermRel.setPerId(permId);
            funPackagePermRel.setTenantId(Constant.DEFAULT_TENANT);
            this.funPackageGateway.InsertFunPackagePermRelDao(funPackagePermRel);
        }
    }

    private String getNewVersion(String ver) {
        int lastIndexOf = ver.lastIndexOf(".") + 1;
        String prefix = ver.substring(0, lastIndexOf);
        String suffix = ver.substring(lastIndexOf);
        return prefix + (Integer.valueOf(suffix) + 1);
    }
}

