/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.funpackage;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.FunPackageGateway;
import com.cicv.foton.admin.domain.system.FunPackage;
import com.cicv.foton.admin.domain.system.FunPackagePermRel;
import com.cicv.foton.admin.domain.utils.DateUtil;
import com.cicv.foton.admin.dto.FunPackageCmd;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FunPackageAddFunPackageCmdExe {
    @Autowired
    private FunPackageGateway funPackageGateway;

    public void execute(FunPackageCmd funPackageCmd) {
        String name = funPackageCmd.getName();
        List permIds = funPackageCmd.getPermIds();
        if (StringUtils.isBlank((String)name) || Objects.isNull(permIds) || permIds.isEmpty()) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        QueryWrapper funPackageQueryWrapper = new QueryWrapper();
        funPackageQueryWrapper.eq((Object)"name", (Object)name);
        funPackageQueryWrapper.eq((Object)"is_deleted", (Object)0);
        if (this.funPackageGateway.selectCount(funPackageQueryWrapper) > 0L) {
            throw new BaseBusinessException(ReturnEnum.FAILED.getCode(), "\u529f\u80fd\u5305\u540d\u79f0\u5df2\u5b58\u5728!");
        }
        FunPackage funPackage = new FunPackage();
        BeanUtils.copyProperties((Object)funPackageCmd, (Object)funPackage);
        Long id = this.funPackageGateway.getNextSeq();
        String version = DateUtil.getTimeStrByFormat((Date)new Date(), (SimpleDateFormat)new SimpleDateFormat("yyyy.MM.dd")) + ".1";
        funPackage.setId(id);
        funPackage.setParentId(id);
        funPackage.setVer(version);
        this.funPackageGateway.insert(funPackage);
        for (Long permId : permIds) {
            FunPackagePermRel funPackagePermRel = new FunPackagePermRel();
            funPackagePermRel.setPkgId(id);
            funPackagePermRel.setPerId(permId);
            funPackagePermRel.setTenantId(Constant.DEFAULT_TENANT);
            this.funPackageGateway.InsertFunPackagePermRelDao(funPackagePermRel);
        }
    }
}

