/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.dict;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.gateway.DictGateway;
import com.cicv.foton.admin.domain.gateway.RedisGateway;
import com.cicv.foton.admin.domain.system.Dict;
import com.cicv.foton.admin.dto.DictCmd;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.core.utils.TreeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DictItemsByTypeCmdExe {
    @Value(value="${spatiotemporal.cache.dictKey:spatiotemporal\\:dict\\:list}")
    private String dictKey;
    @Autowired
    private RedisGateway redisGateway;
    @Resource
    private DictGateway dictGateway;

    public List<Dict> execute(DictCmd cmd) {
        String code = cmd.getCode();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dict_type", (Object)code);
        final List dicts = TreeUtils.list2Tree((List)this.dictGateway.selectDictList(wrapper));
        if (Objects.isNull(dicts)) {
            throw new BaseBusinessException(ReturnEnum.FAILED.getCode(), "\u65e0\u6548\u7684\u5b57\u5178\u5206\u7c7b");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                DictItemsByTypeCmdExe.this.doDictPushRedis(dicts);
            }
        }).start();
        return dicts;
    }

    void doDictPushRedis(List<Dict> dicts) {
        for (Dict dict : dicts) {
            Map<String, String> subDict;
            if (StringUtils.isNotEmpty((String)dict.getDictType())) {
                subDict = this.redisGateway.getHashValue(this.dictKey, dict.getDictType());
                if (subDict != null) {
                    subDict.put(dict.getValue(), dict.getLabel());
                    this.redisGateway.delHashItem(this.dictKey, dict.getDictType());
                    this.redisGateway.putHashValue(this.dictKey, dict.getDictType(), subDict);
                    continue;
                }
                HashMap<String, String> sub = new HashMap<String, String>();
                sub.put(dict.getValue(), dict.getLabel());
                this.redisGateway.putHashValue(this.dictKey, dict.getDictType(), sub);
                continue;
            }
            subDict = new HashMap<String, String>();
            subDict.put(dict.getValue(), dict.getLabel());
            this.redisGateway.putHashValue(this.dictKey, dict.getDictType(), subDict);
        }
    }
}

