/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.dict;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.gateway.DictGateway;
import com.cicv.foton.admin.domain.gateway.RedisGateway;
import com.cicv.foton.admin.domain.system.Dict;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DictAddCmdExe {
    private static final Logger log = LoggerFactory.getLogger(DictAddCmdExe.class);
    @Value(value="${spatiotemporal.cache.dictKey:spatiotemporal\\:dict\\:list}")
    private String dictKey;
    @Autowired
    private DictGateway dictGateway;
    @Autowired
    private RedisGateway redisGateway;

    public void execute(Dict cmd) {
        if (this.doDeduplicationDice(cmd)) {
            return;
        }
        Dict parent = null;
        Dict dict = new Dict();
        BeanUtils.copyProperties((Object)cmd, (Object)dict);
        dict.setTenantId(Long.valueOf(0L));
        if (cmd.getParentId() != null) {
            parent = this.dictGateway.selectDictById(dict.getParentId());
            if (parent == null) {
                throw new BaseBusinessException("601", "\u6240\u6307\u5b9a\u7684\u5b57\u5178\u5206\u7c7b\u4e0d\u5b58\u5728\u3002");
            }
        } else {
            dict.setParentId(Long.valueOf(0L));
        }
        if (this.dictGateway.insert(dict) < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u6570\u636e\u5b57\u5178\u5931\u8d25\u3002");
        }
        if (StringUtils.isNotEmpty((String)cmd.getDictType())) {
            Map subDict = this.redisGateway.getHashValue(this.dictKey, cmd.getDictType());
            if (subDict != null) {
                subDict.put(dict.getValue(), cmd.getLabel());
                this.redisGateway.delHashItem(this.dictKey, cmd.getDictType());
                this.redisGateway.putHashValue(this.dictKey, cmd.getDictType(), subDict);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(dict.getValue(), cmd.getLabel());
                this.redisGateway.delHashItem(this.dictKey, cmd.getDictType());
                this.redisGateway.putHashValue(this.dictKey, cmd.getDictType(), map);
            }
        } else {
            HashMap<String, String> subDict = new HashMap<String, String>();
            subDict.put(cmd.getValue(), dict.getLabel());
            this.redisGateway.putHashValue(this.dictKey, cmd.getDictType(), subDict);
        }
    }

    private boolean doDeduplicationDice(Dict cmd) {
        log.info("\u67e5\u8be2\u662f\u5426\u91cd\u590d >>> {}", (Object)cmd);
        boolean flag = false;
        if (cmd.getParentId() == null || cmd.getParentId() <= 0L) {
            List parentList;
            QueryWrapper qw = new QueryWrapper();
            ((QueryWrapper)qw.isNull((Object)"parent_id")).eq((Object)"value", (Object)cmd.getValue());
            if (cmd.getId() != null) {
                qw.notIn((Object)"id", new Object[]{cmd.getId()});
            }
            if ((parentList = this.dictGateway.selectDictList(qw)).size() >= 1) {
                log.info("\u5df2\u6709\u76f8\u540c\u673a\u6784\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
                flag = true;
            }
        } else {
            List dictList;
            QueryWrapper qw = new QueryWrapper();
            ((QueryWrapper)qw.eq((Object)"value", (Object)cmd.getValue())).eq((Object)"parent_id", (Object)cmd.getParentId());
            if (cmd.getId() != null) {
                qw.notIn((Object)"id", new Object[]{cmd.getId()});
            }
            if ((dictList = this.dictGateway.selectDictList(qw)).size() >= 1) {
                log.info("\u5df2\u6709\u76f8\u540c\u673a\u6784\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
                flag = true;
            }
        }
        return flag;
    }
}

