/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.appmodel;

import com.cicv.foton.admin.domain.enums.ResultEnum;
import com.cicv.foton.admin.domain.enums.RowTypeEnum;
import com.cicv.foton.admin.domain.gateway.AppModelGateway;
import com.cicv.foton.admin.domain.system.Dict;
import com.cicv.foton.admin.domain.system.dataobject.AppModelMetaDatalDO;
import com.cicv.foton.admin.dto.AppModelCmd;
import com.cicv.foton.admin.dto.clientobject.DataModelCO;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppModelDistributionDataModelQueryCmdExe {
    @Resource
    private AppModelGateway appModelGateway;
    @Autowired
    private CommonService commonService;

    public DataModelCO execute(AppModelCmd cmd) {
        Long modelId = cmd.getModelId();
        Long pamId = cmd.getPamId();
        if (Objects.isNull(modelId)) {
            throw new BaseBusinessException(ResultEnum.ERROR_POST_PARAM.getCode(), ResultEnum.ERROR_POST_PARAM.getMessage());
        }
        List allMetadata = this.appModelGateway.getMetadata(modelId);
        if (allMetadata.isEmpty()) {
            throw new BaseBusinessException(ResultEnum.PACKAGE_MODEL_FEILD_EMPTY.getCode(), ResultEnum.PACKAGE_MODEL_FEILD_EMPTY.getMessage());
        }
        List rowSelectMetadata = allMetadata.stream().filter(m -> Objects.equals(RowTypeEnum.DIM.getRowType(), m.getRowType())).collect(Collectors.toList());
        List funDatamodelRowList = null;
        List funDatamodelColList = null;
        if (!Objects.isNull(pamId)) {
            funDatamodelRowList = this.appModelGateway.getFunDatamodelRowByPamId(pamId);
            funDatamodelColList = this.appModelGateway.getFunDatamodelColByPamId(pamId);
            if (!funDatamodelColList.isEmpty()) {
                Map map = funDatamodelColList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
                allMetadata.forEach(m -> {
                    AppModelMetaDatalDO appModelMetaDatalDO = (AppModelMetaDatalDO)map.get(m.getId());
                    if (!Objects.isNull(appModelMetaDatalDO)) {
                        BeanUtils.copyProperties((Object)appModelMetaDatalDO, (Object)m);
                    }
                });
            }
        }
        Map<String, List<Dict>> dic = this.commonService.getDic();
        return new DataModelCO(funDatamodelRowList, allMetadata, rowSelectMetadata, dic.get("rowOperator"), dic.get("dataType"));
    }
}

