/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.appinfo;

import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.gateway.AppInfoGateway;
import com.cicv.foton.admin.domain.system.AppInfo;
import com.cicv.foton.admin.dto.AppInfoCmd;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppInfoUpdateAppStatusCmdExe {
    @Autowired
    private AppInfoGateway appInfoGateway;

    public ReturnVO<Boolean> execute(AppInfoCmd appInfoCmd) {
        if (Objects.isNull(appInfoCmd)) {
            return new ReturnVO(ReturnEnum.FAILED);
        }
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        AppInfo appInfo = this.appInfoGateway.selectById(appInfoCmd.getId());
        if (Objects.isNull(appInfo)) {
            return new ReturnVO(ReturnEnum.FAILED);
        }
        if (!Objects.isNull(appInfoCmd.getAppStatus())) {
            appInfo.setAppStatus(appInfoCmd.getAppStatus());
        }
        if (!Objects.isNull(appInfoCmd.getAppStatus()) && appInfoCmd.getAppStatus() == Constant.APP_INFO_APP_STATUS) {
            appInfo.setReleaseTime(new Date());
        }
        if (!Objects.isNull(appInfoCmd.getIsEnabled())) {
            appInfo.setIsEnabled(appInfoCmd.getIsEnabled());
        }
        appInfo.setUpdateUser(currentUser.getUsername());
        appInfo.setUpdateTime(new Date());
        Integer flag = this.appInfoGateway.updateById(appInfo);
        if (flag > Constant.ZERO) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED);
    }
}

