/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.appinfo;

import cn.hutool.core.util.ObjUtil;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.gateway.AppInfoGateway;
import com.cicv.foton.admin.domain.gateway.ServiceInfoRelGateway;
import com.cicv.foton.admin.domain.system.AppInfo;
import com.cicv.foton.admin.domain.system.AppServiceRel;
import com.cicv.foton.admin.dto.AppInfoCmd;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppInfoUpdateAppInfoCmdExe {
    @Autowired
    private AppInfoGateway appInfoGateway;
    @Autowired
    private ServiceInfoRelGateway serviceInfoRelGateway;

    @Transactional(rollbackOn={Exception.class})
    public ReturnVO<Boolean> execute(AppInfoCmd appInfoCmd) {
        List config;
        boolean b;
        AppInfo appInfo = new AppInfo();
        BeanUtils.copyProperties((Object)appInfoCmd, (Object)appInfo);
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        appInfo.setUpdateTime(new Date());
        appInfo.setUpdateUser(currentUser.getUsername());
        Integer updateFlag = this.appInfoGateway.updateById(appInfo);
        if (updateFlag >= Constant.ZERO && (b = this.doConfigurationServiceUpdate(config = appInfoCmd.getListApp(), appInfoCmd.getId()))) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED);
    }

    private boolean doConfigurationServiceUpdate(List<Long> config, Long appId) {
        if (ObjUtil.isNull(config)) {
            return true;
        }
        ArrayList<AppServiceRel> list = new ArrayList<AppServiceRel>();
        boolean flag = this.serviceInfoRelGateway.deleteServiceInfoRelByAppId(appId);
        if (!flag) {
            return false;
        }
        for (Long serviceInfo : config) {
            AppServiceRel rel = new AppServiceRel();
            rel.setAppId(appId);
            rel.setSrvId(serviceInfo);
            list.add(rel);
        }
        return this.serviceInfoRelGateway.insertServiceInfoRel(list);
    }
}

