/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.appinfo;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AppInfoGateway;
import com.cicv.foton.admin.domain.system.AppInfo;
import com.cicv.foton.admin.dto.AppInfoCmd;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AppInfoQueryAppInfoResourceListCmdExe {
    @Autowired
    private AppInfoGateway appInfoGateway;

    public IPage<AppInfo> execute(AppInfoCmd appInfoCmd) {
        if (Objects.isNull(appInfoCmd) && Objects.isNull(appInfoCmd.getSize()) && Objects.isNull(appInfoCmd.getCurrent())) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        QueryWrapper appInfoQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)appInfoCmd.getName())) {
            appInfoQueryWrapper.like((Object)"name", (Object)appInfoCmd.getName());
        }
        if (!Objects.isNull(appInfoCmd.getAppStatus()) && appInfoCmd.getAppStatus() == 0L) {
            appInfoQueryWrapper.eq((Object)"app_status", (Object)Constant.APP_STATUS);
        }
        if (!Objects.isNull(appInfoCmd.getAppStatus()) && appInfoCmd.getAppStatus() == 1L) {
            appInfoQueryWrapper.eq((Object)"app_status", (Object)Constant.ZERO);
        }
        appInfoQueryWrapper.eq((Object)"is_deleted", (Object)Constant.IS_DELETE);
        Page appInfoPage = new Page(appInfoCmd.getCurrent().longValue(), appInfoCmd.getSize().longValue());
        return this.appInfoGateway.selectPage(appInfoPage, appInfoQueryWrapper);
    }
}

