/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.appinfo;

import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AppInfoGateway;
import com.cicv.foton.admin.domain.gateway.ServiceInfoRelGateway;
import com.cicv.foton.admin.domain.system.AppInfo;
import com.cicv.foton.admin.dto.AppInfoCmd;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppInfoPageListCmdExe {
    @Autowired
    private AppInfoGateway appInfoGateway;
    @Autowired
    private ServiceInfoRelGateway serviceInfoRelGateway;

    public IPage<AppInfo> execute(AppInfoCmd appInfoCmd) {
        if (ObjUtil.isNull((Object)appInfoCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        if (ObjUtil.isNotEmpty((Object)appInfoCmd)) {
            QueryWrapper appInfoQueryWrapper = new QueryWrapper();
            if (StringUtils.isNotEmpty((String)appInfoCmd.getName())) {
                appInfoQueryWrapper.like((Object)"name", (Object)appInfoCmd.getName());
            }
            if (null != appInfoCmd.getAppStatus() && appInfoCmd.getAppStatus() < 2L) {
                appInfoQueryWrapper.eq((Object)"app_status", (Object)appInfoCmd.getAppStatus());
            }
            appInfoQueryWrapper.orderByDesc((Object)"create_time");
            Page appInfoPage = new Page(appInfoCmd.getCurrent().longValue(), (Objects.equals(Constant.LONG_ZORE, appInfoCmd.getSize()) ? Constant.DEFAULT_SIZE : appInfoCmd.getSize()).longValue());
            IPage appInfoIPage = this.appInfoGateway.selectPage(appInfoPage, appInfoQueryWrapper);
            List records = appInfoIPage.getRecords();
            if (!records.isEmpty()) {
                for (AppInfo record : records) {
                    List configuration = this.serviceInfoRelGateway.queryConfigById(record.getId());
                    record.setConfig(configuration);
                }
            }
            return appInfoIPage;
        }
        return new Page();
    }
}

