/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.appinfo;

import cn.hutool.core.util.ObjUtil;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.PermInfoGateway;
import com.cicv.foton.admin.domain.gateway.PermResourceRelGateway;
import com.cicv.foton.admin.domain.system.PermInfo;
import com.cicv.foton.admin.domain.system.PermResourceRel;
import com.cicv.foton.admin.dto.PermCmd;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;

@Service
public class AppInfoInsertPermissionsCmdExe {
    @Resource
    private PermInfoGateway permInfoGateway;
    @Resource
    private PermResourceRelGateway permResourceRelGateway;

    @Transactional(rollbackOn={Exception.class})
    public ReturnVO<Boolean> execute(PermCmd permCmd) {
        if (ObjUtil.isNull((Object)permCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        Long appId = permCmd.getAppId();
        Long srvId = permCmd.getSrvId();
        PermInfo permInfo = new PermInfo();
        permInfo.setAppId(appId);
        permInfo.setName(permCmd.getPermName());
        permInfo.setRemark(permCmd.getRemark());
        permInfo.setCreateTime(new Date());
        permInfo.setCreateUser(currentUser.getUsername());
        boolean flag = this.permInfoGateway.insetPermInfo(permInfo);
        Long id = permInfo.getId();
        if (flag && (flag = this.doPermResourceRel(id, appId, srvId, permCmd.getAppInfo()))) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED);
    }

    boolean doPermResourceRel(Long permId, Long appId, Long srvId, List<Long> appInfoId) {
        ArrayList<PermResourceRel> listRel = new ArrayList<PermResourceRel>();
        for (Long resId : appInfoId) {
            PermResourceRel rel = new PermResourceRel();
            rel.setPerId(permId);
            rel.setAppId(appId);
            rel.setSrvId(srvId);
            rel.setResId(resId);
            listRel.add(rel);
        }
        return this.permResourceRelGateway.insertPermResourceRel(listRel);
    }
}

