/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.appinfo;

import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.gateway.AppInfoGateway;
import com.cicv.foton.admin.domain.gateway.ServiceInfoRelGateway;
import com.cicv.foton.admin.domain.system.AppInfo;
import com.cicv.foton.admin.domain.system.AppServiceRel;
import com.cicv.foton.admin.dto.AppInfoInsertCmd;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppInfoAddAppInfoCmdExe {
    private static final Logger log = LoggerFactory.getLogger(AppInfoAddAppInfoCmdExe.class);
    @Autowired
    private AppInfoGateway appInfoGateway;
    @Resource
    private ServiceInfoRelGateway serviceInfoRelGateway;

    @Transactional(rollbackFor={Exception.class})
    public ReturnVO<Boolean> execute(AppInfoInsertCmd appInfoCmd) {
        if (Objects.isNull(appInfoCmd)) {
            return new ReturnVO(ReturnEnum.ERROR_POST_PARAM);
        }
        this.appInfoGateway.isNameRepeat(appInfoCmd.getName());
        AppInfo appInfo = new AppInfo();
        BeanUtils.copyProperties((Object)appInfoCmd, (Object)appInfo);
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        Long tenantId = currentUser.getTenantId();
        if (null != tenantId) {
            appInfo.setTenantId(tenantId);
        } else {
            appInfo.setTenantId(Constant.ZEROL);
        }
        appInfo.setAppType(Integer.valueOf(0));
        appInfo.setTenantUsable(Constant.TENANT_USABLE_ONE);
        appInfo.setAppStatus(Constant.ZEROL);
        appInfo.setCreateUser(currentUser.getCreateUser());
        appInfo.setCreateTime(new Date());
        appInfo.setIsDeleted(Constant.ZERO.intValue());
        Integer insertFlag = this.appInfoGateway.insert(appInfo);
        if (insertFlag > Constant.ZERO) {
            Long id = appInfo.getId();
            log.info("====ID===#{id}" + id);
            boolean b = this.doServiceInfoRelGateway(appInfoCmd.getListApp(), id);
            if (b) {
                return new ReturnVO(ReturnEnum.SUCCESS);
            }
        }
        return new ReturnVO(ReturnEnum.FAILED);
    }

    private synchronized boolean doServiceInfoRelGateway(List<Long> relList, Long appId) {
        ArrayList<AppServiceRel> list = new ArrayList<AppServiceRel>();
        for (Long serviceInfoRel : relList) {
            AppServiceRel rel = new AppServiceRel();
            rel.setAppId(appId);
            rel.setSrvId(serviceInfoRel);
            list.add(rel);
        }
        return this.serviceInfoRelGateway.insertServiceInfoRel(list);
    }
}

