/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.admin;

import com.cicv.foton.admin.domain.enums.DeseTypeEnum;
import com.cicv.foton.admin.domain.enums.ResultEnum;
import com.cicv.foton.admin.domain.gateway.AppModelGateway;
import com.cicv.foton.admin.domain.gateway.DictGateway;
import com.cicv.foton.admin.domain.system.Dict;
import com.cicv.foton.admin.domain.system.FunDatamodelCol;
import com.cicv.foton.admin.domain.system.FunDatamodelRow;
import com.cicv.foton.admin.domain.system.FunPackageAppModel;
import com.cicv.foton.admin.dto.AppModelCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppModelDistributionDataModelAddCmdExe {
    @Autowired
    private CommonService commonService;
    @Resource
    private AppModelGateway appModelGateway;
    @Resource
    private DictGateway dictGateway;
    @Autowired
    private RedisDao redisDao;
    private Map<String, List<Dict>> dic;

    public void execute(AppModelCmd cmd) {
        Long packageId = cmd.getPackageId();
        Long appId = cmd.getAppId();
        Long id = cmd.getModelId();
        String modelNote = cmd.getModelNote();
        List funDatamodelColList = cmd.getFunDatamodelColList();
        if (Objects.isNull(packageId) || Objects.isNull(appId) || Objects.isNull(id) || Objects.isNull(funDatamodelColList) || funDatamodelColList.isEmpty() || Objects.isNull(modelNote)) {
            throw new BaseBusinessException(ResultEnum.ERROR_POST_PARAM.getCode(), ResultEnum.ERROR_POST_PARAM.getMessage());
        }
        Long pamId = this.getPamId(packageId, appId, id);
        this.dic = this.commonService.getDic();
        List funDatamodelRowList = cmd.getFunDatamodelRowList();
        this.insertRowData(pamId, funDatamodelRowList);
        this.insertColData(pamId, funDatamodelColList, funDatamodelRowList);
        this.savePackageInfoForRedis(packageId, appId, modelNote, funDatamodelRowList, funDatamodelColList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Long getPamId(Long packageId, Long appId, Long id) {
        Long pamId = null;
        FunPackageAppModel funPackageAppMode = this.appModelGateway.getFunPackageAppMode(packageId, appId, id);
        if (!Objects.isNull(funPackageAppMode)) return funPackageAppMode.getId();
        FunPackageAppModel funPackageAppModel = new FunPackageAppModel(packageId, appId, id);
        int insertFunPackageAppMode = this.appModelGateway.insertFunPackageAppMode(funPackageAppModel);
        if (insertFunPackageAppMode <= 0) throw new BaseBusinessException(ResultEnum.FAILED.getCode(), ResultEnum.FAILED.getMessage());
        return funPackageAppModel.getId();
    }

    private void insertRowData(Long pamId, List<FunDatamodelRow> funDatamodelRowList) {
        this.appModelGateway.deleteRowData(pamId);
        if (!Objects.isNull(funDatamodelRowList) && !funDatamodelRowList.isEmpty()) {
            funDatamodelRowList.forEach(m -> {
                m.setId(null);
                m.setPamId(pamId);
            });
            this.appModelGateway.insertRowData(funDatamodelRowList);
        }
    }

    private void insertColData(Long pamId, List<FunDatamodelCol> funDatamodelColList, List<FunDatamodelRow> funDatamodelRowList) {
        HashMap map = Objects.isNull(funDatamodelRowList) ? new HashMap() : funDatamodelRowList.stream().collect(Collectors.toMap(FunDatamodelRow::getModelMetaId, Function.identity(), (key1, key2) -> key2));
        this.appModelGateway.deleteColData(pamId);
        funDatamodelColList.forEach(m -> {
            Integer deseType = Objects.isNull(map.get(m.getModelMetaId())) ? DeseTypeEnum.NOT_DIMENSION_COL.getDeseType() : DeseTypeEnum.IS_DIMENSION_COL.getDeseType();
            m.setPamId(pamId);
            m.setDeseType(deseType);
        });
        this.appModelGateway.insertColData(funDatamodelColList);
    }

    private void savePackageInfoForRedis(Long packageId, Long applyId, String modelNote, List<FunDatamodelRow> funDatamodelRowList, List<FunDatamodelCol> funDatamodelColList) {
        String rootkey = "datapackage:" + packageId + ":" + applyId + ":" + modelNote + ":";
        String rowKey = rootkey + "row";
        String colKey = rootkey + "col";
        this.redisDao.del(new String[]{rowKey, colKey});
        if (!Objects.isNull(funDatamodelRowList) && !funDatamodelRowList.isEmpty()) {
            this.redisDao.putHashMap(rowKey, this.getMapForRow(funDatamodelRowList));
        }
        if (!Objects.isNull(funDatamodelColList) && !funDatamodelColList.isEmpty()) {
            this.redisDao.putHashMap(colKey, this.getMapForCol(funDatamodelColList));
        }
    }

    private Map getMapForRow(List<FunDatamodelRow> funDatamodelRowList) {
        List<Dict> list = this.dic.get("rowOperator");
        Map mapDic = list.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
        HashMap allMap = new HashMap();
        if (!Objects.isNull(funDatamodelRowList)) {
            funDatamodelRowList.forEach(m -> {
                HashMap map = new HashMap();
                map.put("oper", mapDic.get(m.getDictOperatorId()));
                map.put("val", Objects.isNull(m.getCondValue()) ? null : Arrays.asList(m.getCondValue().split(",")));
                allMap.put(m.getFieldNote(), map);
            });
        }
        return allMap;
    }

    private Map getMapForCol(List<FunDatamodelCol> funDatamodelColList) {
        HashMap allMap = new HashMap();
        if (!funDatamodelColList.isEmpty()) {
            funDatamodelColList.forEach(m -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String replacedChar = m.getReplacedChar();
                if (!StringUtils.isBlank((String)replacedChar)) {
                    map.put("startInclude", m.getStartInclude());
                    map.put("endExclude", m.getEndExclude());
                    map.put("replacedChar", m.getReplacedChar());
                }
                allMap.put(m.getFieldNote(), map);
            });
        }
        return allMap;
    }
}

