/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.admin;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.dataobject.AdminUserDO;
import com.cicv.foton.admin.dto.clientobject.AdminUserCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AdminUserListCmdExe {
    @Resource
    private AdminUserGateway adminUserGateway;
    @Resource
    private CommonService commonService;

    public IPage<AdminUserDO> execute(AdminUserCmd appInfoCmd) {
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        if (null == tenantId) {
            return new Page();
        }
        if (Objects.isNull(appInfoCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        AdminUserDO adminUser = new AdminUserDO();
        adminUser.setUserName(appInfoCmd.getUserName());
        adminUser.setTenant(appInfoCmd.getTenant());
        if (!Objects.isNull(appInfoCmd.getUserType()) && !appInfoCmd.getUserType().equals(Constant.USER_TYPE_THEN)) {
            adminUser.setUserType(appInfoCmd.getUserType());
        }
        if (!Objects.isNull(appInfoCmd.getIsEnabled()) && appInfoCmd.getIsEnabled() < Constant.TEW) {
            adminUser.setIsEnabled(appInfoCmd.getIsEnabled());
        }
        long current = appInfoCmd.getCurrent();
        long size = appInfoCmd.getSize();
        Page appInfoPage = new Page(current, Objects.equals(Constant.LONG_ZORE, size) ? Constant.DEFAULT_SIZE : size);
        IPage adminUserDOIPage = this.adminUserGateway.selectAdminUserPage(appInfoPage, adminUser, tenantId);
        List records = adminUserDOIPage.getRecords();
        for (AdminUserDO record : records) {
            if (!StringUtils.isBlank((String)record.getUserName())) continue;
            record.setUserName("\u6e38\u5ba2-" + record.getPhone());
        }
        return adminUserDOIPage;
    }
}

