/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.admin;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.gateway.AdminUserInfoGateway;
import com.cicv.foton.admin.domain.gateway.RedisGateway;
import com.cicv.foton.admin.domain.gateway.UserGateway;
import com.cicv.foton.admin.domain.system.AdminUserInfo;
import com.cicv.foton.admin.dto.clientobject.AdminUserInfoCmd;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AdminUserInfoUpdatePasswordCmdExe {
    public static final String UPDATE_PASSWORD_REDIS = "foton:login:updatepassword:";
    @Resource
    private AdminUserInfoGateway adminUserInfoGateway;
    @Resource
    private UserGateway userGateway;
    @Resource
    private RedisGateway redisGateway;

    public boolean execute(AdminUserInfoCmd userInfoCmd) {
        boolean flag = false;
        String msg = userInfoCmd.getPhoneOrEmail();
        QueryWrapper wq = new QueryWrapper();
        wq.eq((Object)"fullname", (Object)msg);
        AdminUserInfo userInfo = this.adminUserInfoGateway.selectUserInfo(wq);
        String confirmPassword = userInfoCmd.getConfirmPassword();
        User user = this.userGateway.selectById(userInfo.getUserId());
        user.setPassword(confirmPassword);
        user.setUpdateTime(new Date());
        user.setUpdateUser(userInfo.getFullname());
        flag = this.doUpdateUserPwd(user);
        String redisKey = UPDATE_PASSWORD_REDIS + user.getId();
        this.doSendRedisUserId(redisKey, user.getId());
        return flag;
    }

    public boolean doUpdateUserPwd(User user) {
        int i = this.userGateway.updateUserById(user);
        return i > 0;
    }

    private void doSendRedisUserId(String redisKey, Long userId) {
        this.redisGateway.saveUserUpdateById(redisKey, userId);
    }
}

