/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.admin;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.UserTypeEnum;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.gateway.TenantGateway;
import com.cicv.foton.admin.domain.system.AdminMember;
import com.cicv.foton.admin.domain.system.AdminMessage;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.domain.system.Tenant;
import com.cicv.foton.admin.domain.utils.MD5Util;
import com.cicv.foton.admin.dto.clientobject.AdminUserCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Resource;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdminUserCreatUserCmdExe {
    @Resource
    private AdminUserGateway adminUserGateway;
    @Resource
    private AdminUserGateway adminMemberGateway;
    @Resource
    private TenantGateway tenantGateway;
    @Resource
    private CommonService commonService;

    @Transactional(rollbackFor={Exception.class})
    public ReturnVO execute(AdminUserCmd user) {
        User serviceCurrentUser = this.commonService.getCurrentUser();
        Long userTenantId = serviceCurrentUser.getTenantId();
        if (null == userTenantId) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        if (Objects.isNull(user)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        AdminUser adminUser = new AdminUser();
        AdminUser selectUserInfo = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminUser::getPhone, (Object)user.getPhone()));
        if (null != selectUserInfo) {
            throw new BaseBusinessException(CommonEnum.PHONE_IS_EXIST_FOT_MEMBER.getCode(), CommonEnum.PHONE_IS_EXIST_FOT_MEMBER.getMessage());
        }
        Long count = this.adminUserGateway.selectCountByWrapper((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AdminUser::getMailBox, (Object)user.getMailBox()));
        if (count > 0L) {
            throw new BaseBusinessException(CommonEnum.EMAIL_IS_EXIST_FOT_MEMBER.getCode(), CommonEnum.EMAIL_IS_EXIST_FOT_MEMBER.getMessage());
        }
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        adminUser.setUserName(user.getPhone());
        adminUser.setMailBox(user.getMailBox());
        adminUser.setNaCode(user.getNoCode());
        adminUser.setRealName(user.getUserName());
        String pwd = MD5Util.encode((String)"123456");
        adminUser.setPassword(pwd);
        adminUser.setCreateUser(currentUser.getUsername());
        adminUser.setCreateTime(new Date());
        adminUser.setUpdateTime(new Date());
        adminUser.setPhone(user.getPhone());
        adminUser.setUserType(UserTypeEnum.VISITOR.getStatus());
        adminUser.setTenantId(userTenantId);
        adminUser.setIsEnabled(Constant.ISNOENABLE);
        this.adminUserGateway.insertAdminUser(adminUser);
        List tenantId = user.getTenantId();
        if (null != tenantId && !tenantId.isEmpty()) {
            this.doAdminMessageInsert(user, adminUser.getId(), adminUser);
        }
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    private void doAdminMessageInsert(AdminUserCmd user, Long userId, AdminUser adminUser) {
        QueryWrapper delete = new QueryWrapper();
        delete.eq((Object)"user_id", (Object)userId);
        this.adminMemberGateway.deleteAdminMember(delete);
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        String username = currentUser.getUsername();
        Date date = new Date();
        List tenantId = user.getTenantId();
        List tenantList = this.tenantGateway.queryAdminTenantList((QueryWrapper)new QueryWrapper().in((Object)"id", (Collection)tenantId));
        for (Tenant tenant : tenantList) {
            Long id = tenant.getId();
            AdminMember adminMember = new AdminMember();
            String code = this.doGenerateRoleCode(adminUser.getRealName());
            adminMember.setCode(code);
            adminMember.setUserId(userId);
            adminMember.setTenantId(id);
            adminMember.setRealName(user.getUserName());
            adminMember.setEmail(user.getMailBox());
            adminMember.setIsEnabled(Constant.ISENABLE);
            adminMember.setVersion(Constant.ROLE_VERSION);
            adminMember.setPhone(user.getPhone());
            adminMember.setOrgId(null);
            adminMember.setIsConfirm(Constant.ZERO);
            adminMember.setNaCode(user.getNoCode());
            adminMember.setIsMaster(Constant.ISMASTER);
            this.adminMemberGateway.insertBatchMember(adminMember);
            AdminMessage msg = new AdminMessage();
            msg.setSourceId(adminMember.getId());
            msg.setSourceTblName("admin_user");
            msg.setMsgStatus(Constant.ZERO);
            msg.setReadStatus(Constant.ZERO);
            msg.setMessage(String.format("%s\u7ba1\u7406\u5458\u9080\u8bf7\u60a8\u52a0\u5165%s\u79df\u6237", currentUser.getRealName(), tenant.getName()));
            msg.setRecipientId(userId);
            msg.setTenantId(id);
            msg.setCreateUser(username);
            msg.setCreateTime(date);
            this.adminMemberGateway.insertBatchMessage(msg);
        }
    }

    private String doGenerateRoleCode(String userName) {
        Random random = new Random();
        int randomNumber = random.nextInt(9000) + 1000;
        String pinyinstr = "";
        char[] newChar = userName.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < newChar.length; ++i) {
            if (newChar[i] > '\u0080') {
                try {
                    pinyinstr = pinyinstr + PinyinHelper.toHanyuPinyinStringArray((char)newChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinstr = pinyinstr + newChar[i];
        }
        return pinyinstr.toUpperCase() + randomNumber;
    }
}

