/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.admin;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.AdminMemberCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AdminMemberTenantQueryListCmdExe {
    @Resource
    private AdminMemberGateway adminMemberGateway;
    @Resource
    private AdminUserGateway adminUserGateway;
    @Resource
    private CommonService commonService;

    public List<AdminUser> execute(AdminMemberCmd adminMemberCmd) {
        if (Objects.isNull(adminMemberCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        if (null == tenantId) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)adminMemberCmd.getAdminName())) {
            wrapper.like((Object)"real_name", (Object)adminMemberCmd.getAdminName());
        }
        if (tenantId != 0L) {
            wrapper.eq((Object)"tenant_id", (Object)tenantId);
        }
        wrapper.eq((Object)"is_enabled", (Object)Constant.IS_ENABLE);
        wrapper.orderByDesc((Object)"update_time");
        List adminUsers = this.adminUserGateway.queryAdminUser(wrapper);
        for (AdminUser adminUser : adminUsers) {
            if (!StringUtils.isBlank((CharSequence)adminUser.getRealName())) continue;
            adminUser.setRealName("\u6e38\u5ba2-" + adminUser.getPhone());
        }
        return adminUsers;
    }
}

