/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import cn.spatiotemporal.web.core.annotation.UserLog;
import cn.spatiotemporal.web.core.constants.enums.PermissionType;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import cn.spatiotemporal.web.core.permission.PermissionSource;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.cicv.foton.admin.api.IUserInfoService;
import com.cicv.foton.admin.api.IUserService;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.domain.system.UserInfo;
import com.cicv.foton.admin.dto.AdminUserCmd;
import com.cicv.foton.admin.dto.ReserPasswprdCmd;
import com.cicv.foton.admin.dto.UserCmd;
import com.cicv.foton.admin.dto.UserInfoCmd;
import com.cicv.foton.admin.dto.UserPasswordCmd;
import com.cicv.foton.admin.dto.UserRegistCmd;
import com.cicv.foton.admin.dto.UserUpdatePhoneCmd;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin
@RequestMapping(value={"/user"})
@Api(tags={"\u7cfb\u7edf\u7528\u6237\u7ba1\u7406"})
public class UserController {
    @Autowired
    private IUserService userService;
    @Autowired
    private IUserInfoService userInfoService;

    @UserLog(value="\u7528\u6237\u5217\u8868")
    @ApiOperation(value="\u7528\u6237\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/page"})
    @PermissionSource(code="userManage", name="\u7528\u6237\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<IPage<UserCmd>> page(@RequestBody @ApiParam UserCmd userVO) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.userService.page(userVO));
    }

    @UserLog(value="\u5f97\u5230\u7528\u6237\u4fe1\u606f")
    @ApiOperation(value="\u5f97\u5230\u7528\u6237\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/getUser"})
    @PermissionSource(code="userManage", name="\u7528\u6237\u67e5\u8be2", permType=PermissionType.BUTTON)
    public ReturnVO<User> page(@RequestParam(value="userId") @ApiParam Long userId) {
        UserCmd userCmd = new UserCmd();
        userCmd.setUserId(userId.longValue());
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.userService.getUser(userCmd));
    }

    @UserLog(value="\u65b0\u589e\u7528\u6237")
    @ApiOperation(value="\u65b0\u589e\u7528\u6237", notes="\u65e0")
    @PostMapping(value={"/add"})
    @PermissionSource(code="userManage", name="\u65b0\u589e\u7528\u6237", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> add(@RequestBody @ApiParam User user) {
        return this.userService.addUser(user);
    }

    @UserLog(value="\u66f4\u65b0\u7528\u6237")
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237", notes="\u65e0")
    @PostMapping(value={"/update"})
    @PermissionSource(code="userManage", name="\u7f16\u8f91\u7528\u6237", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> update(@RequestBody @ApiParam User user) {
        return this.userService.updateUser(user);
    }

    @UserLog(value="\u5220\u9664\u7528\u6237")
    @ApiOperation(value="\u5220\u9664\u7528\u6237", notes="\u65e0")
    @PostMapping(value={"/delete"})
    @PermissionSource(code="userManage", name="\u5220\u9664\u7528\u6237", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> delete(@RequestParam(value="userId") @ApiParam Long userId) {
        UserCmd user = new UserCmd();
        user.setId(userId.longValue());
        return this.userService.deleteUser(user);
    }

    @UserLog(value="\u4e0a\u4f20\u7528\u6237\u5934\u50cf")
    @ApiOperation(value="\u4e0a\u4f20\u7528\u6237\u5934\u50cf", notes="\u65e0")
    @PostMapping(value={"/upload"})
    public ReturnVO<?> upload(@RequestPart(value="file") MultipartFile file) {
        String uploadPath = this.userInfoService.upload(file);
        if (StringUtils.isNotEmpty((CharSequence)uploadPath)) {
            return new ReturnVO(ReturnEnum.SUCCESS, (Object)uploadPath);
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u4e0a\u4f20\u7528\u6237\u5934\u50cf\u5931\u8d25");
    }

    @UserLog(value="\u83b7\u53d6\u7528\u6237\u6269\u5c55\u4fe1\u606f")
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6269\u5c55\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/getUserInfo"})
    @PermissionSource(code="userManage", name="\u7528\u6237\u67e5\u8be2", permType=PermissionType.BUTTON)
    public ReturnVO<UserInfo> getUserInfo(@RequestParam @ApiParam Long userId) {
        UserInfoCmd userInfoCmd = new UserInfoCmd();
        userInfoCmd.setUserId(userId);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.userInfoService.getUserInfo(userInfoCmd));
    }

    @UserLog(value="\u4fdd\u5b58\u7528\u6237\u6269\u5c55\u4fe1\u606f")
    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u6269\u5c55\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/saveExtUser"})
    @PermissionSource(code="userManage", name="\u7f16\u8f91\u7528\u6237", permType=PermissionType.BUTTON)
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="fullname", value="\u7528\u6237\u59d3\u540d(\u4e2d\u6587)", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="userPwd", value="\u5bc6\u7801", required=true, paramType="query", dataType="String")})
    public ReturnVO saveExtUser(@RequestBody UserInfo userInfo) {
        UserInfoCmd userInfoCmd = new UserInfoCmd();
        BeanUtils.copyProperties((Object)userInfo, (Object)userInfoCmd);
        if (userInfoCmd.getId() != null) {
            this.userInfoService.updateUserInfo(userInfoCmd);
        } else {
            this.userInfoService.inset(userInfoCmd);
        }
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @ApiOperation(value="\u540c\u6b65\u79df\u6237", notes="\u65e0")
    @GetMapping(value={"/synTenant"})
    public ReturnVO synTenant() {
        this.userService.synTenant();
        return new ReturnVO();
    }

    @UserLog(value="\u6821\u9a8c\u91cd\u7f6e\u5bc6\u7801\u7684\u9a8c\u8bc1\u7801")
    @ApiOperation(value="\u6821\u9a8c\u91cd\u7f6e\u5bc6\u7801\u7684\u9a8c\u8bc1\u7801", notes="\u65e0")
    @PostMapping(value={"/resetPasswordVerifyCode"})
    public ReturnVO<String> resetPasswordVerifyCode(@RequestBody @ApiParam ReserPasswprdCmd reserPasswprdCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.userService.resetPasswordVerifyCode(reserPasswprdCmd));
    }

    @UserLog(value="\u91cd\u7f6e\u5bc6\u7801/\u4fee\u6539\u521d\u59cb\u5bc6\u7801")
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801/\u4fee\u6539\u521d\u59cb\u5bc6\u7801", notes="\u65e0")
    @PostMapping(value={"/resetPassword"})
    public ReturnVO<Boolean> resetPassword(@RequestBody @ApiParam UserPasswordCmd userPasswordCmd) {
        this.userService.resetPassword(userPasswordCmd);
        return new ReturnVO();
    }

    @ApiOperation(value="\u7528\u6237\u6ce8\u518c", notes="\u65e0")
    @PostMapping(value={"/userRegist"})
    public ReturnVO userRegist(@RequestBody @ApiParam(value="\u7528\u6237\u6ce8\u518c", required=true) UserRegistCmd userRegistCmd) {
        this.userService.userRegist(userRegistCmd);
        return new ReturnVO();
    }

    @ApiOperation(value="\u4e2a\u4eba\u4e2d\u5fc3-\u4fee\u6539\u624b\u673a\u53f7-\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801", notes="\u65e0")
    @PostMapping(value={"/sendCodeForupdatePhone"})
    public ReturnVO sendCodeForupdatePhone(@RequestBody @ApiParam(value="\u4e2a\u4eba\u4e2d\u5fc3-\u4fee\u6539\u624b\u673a\u53f7-\u53d1\u9001\u9a8c\u8bc1\u7801", required=true) UserUpdatePhoneCmd userUpdatePhoneCmd) {
        this.userService.sendCodeForupdatePhone(userUpdatePhoneCmd);
        return new ReturnVO();
    }

    @ApiOperation(value="\u4e2a\u4eba\u4e2d\u5fc3-\u4fee\u6539\u624b\u673a\u53f7-\u524d\u7f6e\u6821\u9a8c(\u624b\u673a\u53f7|\u90ae\u7bb1|\u5bc6\u7801)", notes="\u65e0")
    @PostMapping(value={"/checkUpdatePhoneCheck"})
    public ReturnVO updatePhoneCheck(@RequestBody @ApiParam(value="\u4e2a\u4eba\u4e2d\u5fc3-\u4fee\u6539\u624b\u673a\u53f7-\u524d\u7f6e\u6821\u9a8c(\u624b\u673a\u53f7|\u90ae\u7bb1|\u5bc6\u7801)", required=true) UserUpdatePhoneCmd userUpdatePhoneCmd) {
        return this.userService.updatePhoneCheck(userUpdatePhoneCmd);
    }

    @ApiOperation(value="\u4e2a\u4eba\u4e2d\u5fc3-\u4fee\u6539\u624b\u673a\u53f7", notes="\u65e0")
    @PostMapping(value={"/updatePhone"})
    public ReturnVO updatePhone(@RequestBody @ApiParam(value="\u4e2a\u4eba\u4e2d\u5fc3-\u4fee\u6539\u624b\u673a\u53f7", required=true) UserUpdatePhoneCmd userUpdatePhoneCmd) {
        this.userService.updatePhone(userUpdatePhoneCmd);
        return new ReturnVO();
    }

    @UserLog(value="\u4e2a\u4eba\u4e2d\u5fc3-\u4fee\u6539\u5bc6\u7801")
    @ApiOperation(value="\u4e2a\u4eba\u4e2d\u5fc3-\u4fee\u6539\u5bc6\u7801", notes="\u65e0")
    @PostMapping(value={"/updatePassword"})
    public ReturnVO<Boolean> updatePassword(@RequestBody @ApiParam UserPasswordCmd userPasswordCmd) {
        this.userService.updatePassword(userPasswordCmd);
        return new ReturnVO();
    }

    @UserLog(value="\u6839\u636e\u624b\u673a\u53f7\u548c\u56fd\u522b\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u548c\u56fd\u522b\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/getUserByPhone"})
    public ReturnVO<AdminUser> getUserByPhone(@RequestBody @ApiParam AdminUserCmd adminUserCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.userService.getUserByPhone(adminUserCmd));
    }
}

