/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import cn.spatiotemporal.commons.file.service.FileService;
import cn.spatiotemporal.commons.file.vo.FileInfo;
import cn.spatiotemporal.web.core.annotation.UserLog;
import cn.spatiotemporal.web.core.constants.enums.PermissionType;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import cn.spatiotemporal.web.core.permission.PermissionSource;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.cicv.foton.admin.api.AdminMemberService;
import com.cicv.foton.admin.api.IFunPackageService;
import com.cicv.foton.admin.api.ITenantService;
import com.cicv.foton.admin.domain.system.dataobject.TeanantDO;
import com.cicv.foton.admin.domain.system.dataobject.TenantCmd;
import com.cicv.foton.admin.domain.system.dataobject.TenantInfoCo;
import com.cicv.foton.admin.dto.AdminMemberCmd;
import com.cicv.foton.admin.dto.TenantPackageCmd;
import com.cicv.foton.admin.dto.clientobject.LoginCO;
import com.cicv.foton.admin.dto.clientobject.TenantCo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin
@RequestMapping(value={"/tenant"})
@Api(tags={"\u79df\u6237\u7ba1\u7406"})
public class TenantController {
    @Autowired
    private ITenantService tenantService;
    @Value(value="${uploadservice.fileserver}")
    private String fileImage;
    @Resource
    private IFunPackageService funPackageService;
    @Resource
    private AdminMemberService adminMemberService;
    @Resource
    private FileService fileService;

    @ApiOperation(value="\u65b0\u589e\u79df\u6237", notes="\u65e0")
    @PostMapping(value={"/add"})
    @PermissionSource(code="tenant", name="\u65b0\u589e\u79df\u6237", permType=PermissionType.BUTTON)
    @Transactional
    public ReturnVO<Boolean> add(@Validated @RequestBody @ApiParam(value="\u533a\u57df\u5165\u53c2\u5b9e\u4f53") TenantCmd tenantCmd) {
        return this.tenantService.addTenant(tenantCmd);
    }

    @ApiOperation(value="\u4e0a\u4f20\u56fe\u7247", notes="\u65e0")
    @PostMapping(value={"/addFile"})
    @PermissionSource(code="tenant", name="\u4e0a\u4f20\u56fe\u7247", permType=PermissionType.BUTTON)
    @Transactional
    public ReturnVO<FileInfo> addFile(@RequestBody MultipartFile multipartFile) {
        FileInfo fileInfo = this.fileService.uploadFile(multipartFile);
        fileInfo.setName(fileInfo.getUrl());
        fileInfo.setUrl(this.fileImage + fileInfo.getUrl());
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)fileInfo);
    }

    @UserLog(value="\u79df\u6237\u8be6\u60c5")
    @ApiOperation(value="\u79df\u6237\u8be6\u60c5", notes="\u65e0")
    @PostMapping(value={"/getTenant"})
    @PermissionSource(code="tenant", name="\u79df\u6237\u8be6\u60c5", permType=PermissionType.BUTTON)
    public ReturnVO<TenantInfoCo> getTenantById(@RequestBody @ApiParam(value="\u533a\u57df\u5165\u53c2\u5b9e\u4f53") TenantCmd tenantCmd) {
        return this.tenantService.getTenantById(tenantCmd);
    }

    @UserLog(value="\u66f4\u65b0\u79df\u6237")
    @ApiOperation(value="\u66f4\u65b0\u79df\u6237", notes="\u65e0")
    @PostMapping(value={"/update"})
    @PermissionSource(code="tenant", name="\u66f4\u65b0\u79df\u6237", permType=PermissionType.BUTTON)
    @Transactional
    public ReturnVO<Boolean> update(@Validated @RequestBody @ApiParam(value="\u79df\u6237\u5165\u53c2\u5b9e\u4f53") TenantCmd tenantCmd) {
        return this.tenantService.updateTenant(tenantCmd);
    }

    @UserLog(value="\u5220\u9664\u79df\u6237")
    @ApiOperation(value="\u5220\u9664\u79df\u6237", notes="\u65e0")
    @PostMapping(value={"/delete"})
    @PermissionSource(code="tenant", name="\u5220\u9664\u79df\u6237", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> delete(@RequestBody @ApiParam(value="\u79df\u6237\u5165\u53c2\u5b9e\u4f53") TenantCmd tenantCmd) {
        return this.tenantService.deleteTenant(tenantCmd);
    }

    @UserLog(value="\u542f\u7528/\u505c\u7528\u79df\u6237")
    @ApiOperation(value="\u542f\u7528/\u505c\u7528\u79df\u6237", notes="\u65e0")
    @PostMapping(value={"/enableOrDisableTenant"})
    @PermissionSource(code="enableOrDisableTenant", name="\u542f\u7528/\u505c\u7528\u79df\u6237", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> enableOrDisableTenant(@RequestBody @ApiParam(value="\u79df\u6237\u5165\u53c2\u5b9e\u4f53") TenantCmd tenantCmd) {
        return this.tenantService.updateTenantEnableOrDisableState(tenantCmd);
    }

    @ApiOperation(value="\u79df\u6237\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/page"})
    @PermissionSource(code="tenant", name="\u79df\u6237\u5217\u8868\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<IPage<TeanantDO>> page(@RequestBody @ApiParam(value="\u79df\u6237\u5165\u53c2\u5b9e\u4f53") TenantCmd tenantCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.tenantService.pageList(tenantCmd));
    }

    @ApiOperation(value="\u65b0\u589e-\u529f\u80fd\u5305\u5217\u8868-\u652f\u6301\u6a21\u7cca\u641c\u7d22", notes="\u65e0")
    @PostMapping(value={"/tenantFunPackage"})
    @PermissionSource(code="tenantFunPackage", name="\u79df\u6237\u5217\u8868\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<TenantCo>> tenantFunPackage(@RequestBody @ApiParam(value="\u529f\u80fd\u5305\u5217\u8868\u5165\u53c2\u5b9e\u4f53") TenantPackageCmd tenantCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.funPackageService.queryTenantFunPackage(tenantCmd));
    }

    @ApiOperation(value="\u65b0\u589e-\u83b7\u53d6\u6307\u5b9a\u79df\u6237\u7ba1\u7406\u5458-\u652f\u6301\u6a21\u7cca\u641c\u7d22", notes="\u65e0")
    @PostMapping(value={"/obtainTenant"})
    @PermissionSource(code="obtainTenant", name="\u83b7\u53d6\u6307\u5b9a\u79df\u6237\u7ba1\u7406\u5458-\u652f\u6301\u6a21\u7cca\u641c\u7d22", permType=PermissionType.MENU)
    public ReturnVO obtainTenantAdministrators(@RequestBody @ApiParam(value="\u529f\u80fd\u5305\u5217\u8868\u5165\u53c2\u5b9e\u4f53") AdminMemberCmd adminMemberCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.adminMemberService.queryAdminMemberTenantList(adminMemberCmd));
    }

    @ApiOperation(value="\u79df\u6237\u9009\u62e9", notes="\u65e0")
    @PostMapping(value={"/selectTenant"})
    @PermissionSource(code="selectTenant", name="\u79df\u6237\u9009\u62e9", permType=PermissionType.MENU)
    public ReturnVO<LoginCO> selectTenant(@RequestBody @ApiParam(value="\u79df\u6237\u5165\u53c2\u5b9e\u4f53") TenantCmd tenantCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.tenantService.selectTenant(tenantCmd));
    }

    @ApiOperation(value="\u79df\u6237\u8be6\u60c5-\u529f\u80fd\u5305\u5206\u914d\u8bb0\u5f55", notes="\u65e0")
    @PostMapping(value={"/selectFunPackage"})
    @PermissionSource(code="selectFunPackage", name="\u79df\u6237\u8be6\u60c5-\u529f\u80fd\u5305\u5206\u914d\u8bb0\u5f55", permType=PermissionType.MENU)
    public ReturnVO selectFunPackage(@RequestBody @ApiParam(value="\u529f\u80fd\u5305\u5206\u914d\u8bb0\u5f55") TenantCmd tenantCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.tenantService.selectFunPackage(tenantCmd));
    }
}

