/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import cn.spatiotemporal.web.core.annotation.UserLog;
import cn.spatiotemporal.web.core.constants.enums.PermissionType;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import cn.spatiotemporal.web.core.exception.BaseBusinessException;
import cn.spatiotemporal.web.core.permission.PermissionSource;
import com.cicv.foton.admin.api.IOrgService;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.system.Org;
import com.cicv.foton.admin.dto.OrgCmd;
import com.cicv.foton.admin.dto.clientobject.OrgCo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/org"})
public class OrgController {
    @Autowired
    private IOrgService orgService;

    @UserLog(value="\u67e5\u8be2\u673a\u6784\u8be6\u60c5")
    @ApiOperation(value="\u67e5\u8be2\u673a\u6784\u8be6\u60c5", notes="\u65e0")
    @PostMapping(value={"/get"})
    @PermissionSource(code="orgManage", name="\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2", permType=PermissionType.BUTTON)
    public ReturnVO<Org> getOrg(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") Long id) {
        OrgCmd orgCmd = new OrgCmd();
        orgCmd.setId(id);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.orgService.getByOne(orgCmd));
    }

    @UserLog(value="\u65b0\u589e\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u65b0\u589e\u7ec4\u7ec7\u673a\u6784", notes="\u65e0")
    @PostMapping(value={"/add"})
    @Transactional
    @PermissionSource(code="orgManage", name="\u65b0\u589e\u7ec4\u7ec7\u673a\u6784", permType=PermissionType.BUTTON)
    public ReturnVO<Void> addOrg(@Validated @RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784") OrgCmd orgCmd) {
        Org org = new Org();
        BeanUtils.copyProperties((Object)orgCmd, (Object)org);
        if (this.orgService.queryRepetition(org).booleanValue()) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_ORG_THE_SAME.getCode(), CommonEnum.PERMSSION_ORG_THE_SAME.getMessage());
        }
        this.orgService.addOrg(org);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784", notes="\u65e0")
    @PostMapping(value={"/update"})
    @Transactional
    @PermissionSource(code="orgManage", name="\u7f16\u8f91\u7ec4\u7ec7\u673a\u6784", permType=PermissionType.BUTTON)
    public ReturnVO<Void> updateOrg(@Validated @RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784") OrgCmd orgCmd) {
        Org org = new Org();
        BeanUtils.copyProperties((Object)orgCmd, (Object)org);
        if (this.orgService.queryRepetition(org).booleanValue()) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_ORG_THE_SAME.getCode(), CommonEnum.PERMSSION_ORG_THE_SAME.getMessage());
        }
        this.orgService.updateByOne(org);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784", notes="\u65e0")
    @PostMapping(value={"/deleteList"})
    @Transactional
    @PermissionSource(code="orgManage", name="\u5220\u9664\u7ec4\u7ec7\u673a\u6784", permType=PermissionType.BUTTON)
    public ReturnVO<Void> deleteOrg(@RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") List<Long> ids) {
        OrgCmd orgCmd = new OrgCmd();
        orgCmd.setIds(ids);
        return this.orgService.delete(orgCmd);
    }

    @UserLog(value="\u5355\u6761\u5220\u9664\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u5220\u9664\u7ec4\u7ec7\u673a\u6784", notes="\u65e0")
    @PostMapping(value={"/delete"})
    @Transactional
    @PermissionSource(code="orgManage", name="\u5220\u9664\u7ec4\u7ec7\u673a\u6784", permType=PermissionType.BUTTON)
    public ReturnVO<Void> delete(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") Long id) {
        OrgCmd orgCmd = new OrgCmd();
        orgCmd.setId(id);
        return this.orgService.deleteSingle(orgCmd);
    }

    @UserLog(value="\u67e5\u8be2\u673a\u6784\u76ee\u5f55\u6811")
    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u76ee\u5f55\u6811", notes="\u65e0")
    @PostMapping(value={"/trees"})
    @PermissionSource(code="orgManage", name="\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<OrgCo>> queryTrees(@Validated @RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784") OrgCmd orgCmd) {
        List trees = this.orgService.queryTrees(orgCmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)trees);
    }

    @UserLog(value="\u67e5\u8be2\u4e0b\u4e00\u7ea7\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u7ea7\u7ec4\u7ec7\u673a\u6784", notes="\u65e0")
    @PostMapping(value={"/subOrgs"})
    @PermissionSource(code="orgManage", name="\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<Org>> querySubOrgs(@RequestParam(required=false) @ApiParam(value="\u4e0a\u7ea7\u7ec4\u7ec7\u673a\u6784ID") Long parentId) {
        OrgCmd orgCmd = new OrgCmd();
        orgCmd.setParentId(parentId);
        List list = this.orgService.querySubOrgs(orgCmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)list);
    }
}

