/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import cn.spatiotemporal.web.core.annotation.UserLog;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.alibaba.fastjson.JSON;
import com.cicv.foton.admin.api.ILoginService;
import com.cicv.foton.admin.dto.LoginCmd;
import com.cicv.foton.admin.dto.clientobject.CaptchaCO;
import com.cicv.foton.admin.dto.clientobject.LoginCO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/sso"})
@Api(tags={"\u7cfb\u7edf\u767b\u5f55\u5904\u7406"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private ILoginService loginService;

    @UserLog(value="\u7cfb\u7edf\u767b\u5f55")
    @ApiOperation(value="\u7cfb\u7edf\u767b\u5f55", notes="\u65e0")
    @PostMapping(value={"login/{url}", "/login"})
    public ReturnVO<LoginCO> login(@RequestBody @ApiParam(value="\u767b\u5f55\u5165\u53c2", required=true) LoginCmd cmd, @ApiParam(value="\u79df\u6237\u5bf9\u5e94\u7684url", required=false) @PathVariable(required=false) String url) {
        log.info("\u7cfb\u7edf\u767b\u5f55\uff0c\u624b\u673a\u53f7:{},\u5165\u53c2\uff1a{}", (Object)cmd.getPhone(), (Object)JSON.toJSONString((Object)cmd));
        long startTime = System.currentTimeMillis();
        cmd.setUrl(url);
        ReturnVO returnVO = new ReturnVO(ReturnEnum.SUCCESS, (Object)this.loginService.login(cmd));
        long nedTime = System.currentTimeMillis();
        log.info("\u7cfb\u7edf\u767b\u5f55\u8017\u65f6\uff1a{}", (Object)(nedTime - startTime));
        log.info("\u7cfb\u7edf\u767b\u5f55\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)returnVO.getData()));
        return returnVO;
    }

    @UserLog(value="\u83b7\u53d6\u56fe\u5f62\u9a8c\u8bc1\u7801")
    @ApiOperation(value="\u83b7\u53d6\u56fe\u5f62\u9a8c\u8bc1\u7801", notes="\u65e0")
    @GetMapping(value={"/getGraphic"})
    public ReturnVO<CaptchaCO> getGraphic() {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.loginService.getGraphic());
    }

    @GetMapping(value={"/getBackgroundImg"})
    @ApiOperation(value="\u83b7\u53d6\u80cc\u666f\u56fe", notes="\u83b7\u53d6\u80cc\u666f\u56fe")
    public ReturnVO<String> getBackgroundImg(@ApiParam(value="\u83b7\u53d6\u80cc\u666f\u56fe", required=true) LoginCmd loginCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.loginService.getBackgroundImg(loginCmd));
    }

    @UserLog(value="\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801")
    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801", notes="\u65e0")
    @GetMapping(value={"/sendSmsCode"})
    public ReturnVO<?> sendSmsCode(@ApiParam(value="\u624b\u673a\u53f7", required=true) LoginCmd cmd) {
        this.loginService.sendSmsCode(cmd);
        return new ReturnVO();
    }

    @GetMapping(value={"/logout"})
    @ApiOperation(value="\u767b\u51fa", notes="\u9000\u51fa\u767b\u9646")
    public ReturnVO<Void> logout(@ApiParam(value="\u767b\u51fa", required=true) HttpServletRequest request) {
        LoginCmd cmd = new LoginCmd();
        cmd.setToken(request.getHeader("X-Token"));
        cmd.setUsername(request.getParameter("user"));
        this.loginService.logout(cmd);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }
}

