/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import cn.spatiotemporal.web.core.annotation.UserLog;
import cn.spatiotemporal.web.core.constants.enums.PermissionType;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import cn.spatiotemporal.web.core.permission.PermissionSource;
import com.cicv.foton.admin.api.IDictService;
import com.cicv.foton.admin.domain.system.Dict;
import com.cicv.foton.admin.dto.DictCmd;
import com.cicv.foton.admin.dto.clientobject.DictCO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/dict"})
@Api(tags={"\u6570\u636e\u5b57\u5178\u7ba1\u7406"})
public class DictController {
    @Autowired
    private IDictService dictService;

    @UserLog(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u76ee\u5f55\u6811")
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u76ee\u5f55\u6811", notes="\u65e0")
    @PostMapping(value={"/trees"})
    @PermissionSource(code="dictManage", name="\u6570\u636e\u5b57\u5178\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<Dict>> queryTrees(@RequestParam(required=false) @ApiParam(value="\u4e0a\u7ea7\u6570\u636e\u5b57\u5178ID") Long parentId) {
        DictCmd cmd = new DictCmd();
        cmd.setParentId(parentId);
        List trees = this.dictService.queryTrees(cmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)trees);
    }

    @UserLog(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u76ee\u5f55\u6811\u4e0d\u5305\u542b\u672c\u5c42\u53ea\u7ed9\u5b50\u96c6")
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u76ee\u5f55\u6811\u4e0d\u5305\u542b\u672c\u5c42\u53ea\u7ed9\u5b50\u96c6", notes="\u65e0")
    @PostMapping(value={"/treesSubset"})
    @PermissionSource(code="dictManage", name="\u6570\u636e\u5b57\u5178\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<Dict>> queryTreesSubset(@RequestParam(required=false) @ApiParam(value="\u4e0a\u7ea7\u6570\u636e\u5b57\u5178ID") Long parentId) {
        DictCmd cmd = new DictCmd();
        cmd.setParentId(parentId);
        List trees = this.dictService.queryTreesSubset(cmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)trees);
    }

    @UserLog(value="\u65b0\u589e\u6570\u636e\u5b57\u5178")
    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5b57\u5178", notes="\u65e0")
    @PostMapping(value={"/add"})
    @Transactional
    @PermissionSource(code="dictManage", name="\u65b0\u589e\u6570\u636e\u5b57\u5178", permType=PermissionType.BUTTON)
    public ReturnVO<Void> addDict(@RequestBody @ApiParam(value="\u6570\u636e\u5b57\u5178") Dict cmd) {
        this.dictService.addDict(cmd);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u66f4\u65b0\u6570\u636e\u5b57\u5178")
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u5b57\u5178", notes="\u65e0")
    @PostMapping(value={"/update"})
    @Transactional
    @PermissionSource(code="dictManage", name="\u7f16\u8f91\u6570\u636e\u5b57\u5178", permType=PermissionType.BUTTON)
    public ReturnVO<Void> updateDict(@RequestBody @ApiParam(value="\u6570\u636e\u5b57\u5178") Dict dict) {
        this.dictService.updateDict(dict);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178")
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178", notes="\u65e0")
    @PostMapping(value={"/get"})
    @Transactional
    @PermissionSource(code="dictManage", name="\u6570\u636e\u5b57\u5178\u67e5\u8be2", permType=PermissionType.BUTTON)
    public ReturnVO<Dict> getDict(@RequestParam @ApiParam(value="\u6570\u636e\u5b57\u5178ID") Long id) {
        DictCmd cmd = new DictCmd();
        cmd.setId(id);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.dictService.getById(cmd));
    }

    @UserLog(value="\u5220\u9664\u6570\u636e\u5b57\u5178")
    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5b57\u5178", notes="\u65e0")
    @PostMapping(value={"/delete"})
    @Transactional
    @PermissionSource(code="dictManage", name="\u5220\u9664\u6570\u636e\u5b57\u5178", permType=PermissionType.BUTTON)
    public ReturnVO<Void> deleteDict(@RequestParam @ApiParam(value="\u6570\u636e\u5b57\u5178ID") Long id) {
        DictCmd cmd = new DictCmd();
        cmd.setId(id);
        this.dictService.removeById(cmd);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u6839\u636e\u5b57\u5178\u5206\u7c7bCODE,\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4e0b\u7684\u6240\u6709\u5b57\u5178\u9879")
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u5206\u7c7bCODE,\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4e0b\u7684\u6240\u6709\u5b57\u5178\u9879", notes="\u65e0")
    @PostMapping(value={"/getDictItems"})
    public ReturnVO<DictCO> getDictItemsByDictType(@RequestParam(value="code") @ApiParam(value="\u6570\u636e\u5b57\u5178\u5206\u7c7bCODE") String code) {
        DictCmd cmd = new DictCmd();
        cmd.setCode(code);
        DictCO dictItems = this.dictService.getDictItemsByDictType(cmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)dictItems);
    }

    @UserLog(value="\u6839\u636e\u5b57\u5178\u5206\u7c7bCODE,\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4e0b\u7684\u6240\u6709\u5b57\u5178\u9879")
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u5206\u7c7bCODE,\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4e0b\u7684\u6240\u6709\u5b57\u5178\u9879", notes="\u65e0")
    @PostMapping(value={"/getDictItemLabel"})
    public ReturnVO<String> getDictItemLabel(@RequestParam(value="code") @ApiParam(value="\u6570\u636e\u5b57\u5178\u5206\u7c7bCODE") String code, @RequestParam(value="value") @ApiParam(value="\u6570\u636e\u5b57\u5178\u9879VALUE") String value) {
        DictCmd cmd = new DictCmd();
        cmd.setCode(code);
        DictCO dictItems = this.dictService.getDictItemsByDictType(cmd);
        Map map = dictItems.getMap();
        return new ReturnVO(ReturnEnum.SUCCESS, map.get(value));
    }

    @UserLog(value="\u6839\u636e\u5b57\u5178\u5206\u7c7btype,\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4e0b\u7684\u6240\u6709\u5b57\u5178\u9879")
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u5206\u7c7btype,\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4e0b\u7684\u6240\u6709\u5b57\u5178\u9879", notes="\u65e0")
    @PostMapping(value={"/getDictListByType"})
    public ReturnVO<List<Dict>> getDictListByType(@RequestParam(value="type") @ApiParam(value="\u6570\u636e\u5b57\u5178\u5206\u7c7btype") String type) {
        DictCmd cmd = new DictCmd();
        cmd.setDictType(type);
        List list = this.dictService.getDictListByType(cmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)list);
    }
}

