/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import cn.spatiotemporal.web.core.annotation.UserLog;
import cn.spatiotemporal.web.core.constants.enums.PermissionType;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import cn.spatiotemporal.web.core.permission.PermissionSource;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.cicv.foton.admin.api.IAreaService;
import com.cicv.foton.admin.domain.system.Area;
import com.cicv.foton.admin.dto.AreaCmd;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/area"})
@Api(tags={"\u533a\u57df\u7ba1\u7406"})
public class AreaController {
    @Autowired
    private IAreaService areaService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;

    @ApiOperation(value="\u67e5\u8be2\u533a\u57df\u76ee\u5f55\u6811", notes="\u65e0")
    @PostMapping(value={"/trees"})
    @PermissionSource(code="areaManage", name="\u533a\u57df\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<Area>> queryTrees(@RequestParam(required=false) @ApiParam(value="\u4e0a\u7ea7\u533a\u57dfCode") String parentCode) {
        AreaCmd areaCmd = new AreaCmd();
        areaCmd.setParentCode(parentCode);
        List trees = this.areaService.queryTrees(areaCmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)trees);
    }

    @ApiOperation(value="\u533a\u57df\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/page"})
    @PermissionSource(code="areaManage", name="\u533a\u57df\u5217\u8868\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<IPage<Area>> page(@RequestBody @ApiParam(value="\u533a\u57df\u5165\u53c2\u5b9e\u4f53") AreaCmd areaCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.areaService.page(areaCmd));
    }

    @ApiOperation(value="\u65b0\u589e\u533a\u57df", notes="\u65e0")
    @PostMapping(value={"/add"})
    @PermissionSource(code="areaManage", name="\u65b0\u589e\u533a\u57df", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> add(@RequestBody @ApiParam(value="\u533a\u57df\u5165\u53c2\u5b9e\u4f53") AreaCmd areaCmd) {
        return this.areaService.addArea(areaCmd);
    }

    @UserLog(value="\u533a\u57df\u8be6\u60c5")
    @ApiOperation(value="\u533a\u57df\u8be6\u60c5", notes="\u65e0")
    @PostMapping(value={"/getArea"})
    @PermissionSource(code="areaManage", name="\u7f16\u8f91\u533a\u57df", permType=PermissionType.BUTTON)
    public ReturnVO<Area> getAreaById(@RequestParam(value="areaId") @ApiParam(value="\u533a\u57dfid") Long areaId) {
        AreaCmd areaCmd = new AreaCmd();
        areaCmd.setAreaId(areaId);
        return this.areaService.getAreaById(areaCmd);
    }

    @UserLog(value="\u66f4\u65b0\u533a\u57df")
    @ApiOperation(value="\u66f4\u65b0\u533a\u57df", notes="\u65e0")
    @PostMapping(value={"/update"})
    @PermissionSource(code="areaManage", name="\u7f16\u8f91\u533a\u57df", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> update(@RequestBody @ApiParam(value="\u533a\u57df\u5165\u53c2\u5b9e\u4f53") AreaCmd areaCmd) {
        return this.areaService.updateArea(areaCmd);
    }

    @UserLog(value="\u5220\u9664\u533a\u57df")
    @ApiOperation(value="\u5220\u9664\u533a\u57df", notes="\u65e0")
    @PostMapping(value={"/delete"})
    @PermissionSource(code="areaManage", name="\u5220\u9664\u533a\u57df", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> delete(@RequestParam(value="areaId") @ApiParam(value="\u533a\u57dfid") Long areaId) {
        AreaCmd areaCmd = new AreaCmd();
        areaCmd.setAreaId(areaId);
        return this.areaService.deleteArea(areaCmd);
    }
}

