/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import com.cicv.foton.admin.api.AdminUserInfoService;
import com.cicv.foton.admin.api.IUserService;
import com.cicv.foton.admin.domain.system.UserInfoCo;
import com.cicv.foton.admin.dto.UserPasswordCmd;
import com.cicv.foton.admin.dto.clientobject.AdminUserInfoCmd;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.PermissionType;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.permission.PermissionSource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin
@RequestMapping(value={"/account"})
@Api(tags={"\u767b\u5f55\u8d26\u53f7\u7ba1\u7406"})
public class UserLoginAccountController {
    private static final Logger log = LoggerFactory.getLogger(UserLoginAccountController.class);
    @Resource
    private AdminUserInfoService adminUserInfoService;
    @Autowired
    private IUserService userService;

    @UserLog(value="\u9a8c\u8bc1\u624b\u673a\u53f7\u6216\u8005\u9a8c\u8bc1\u7801")
    @ApiOperation(value="\u9a8c\u8bc1\u624b\u673a\u53f7\u6216\u8005\u9a8c\u8bc1\u7801", notes="\u65e0")
    @PostMapping(value={"/verificationCode"})
    @PermissionSource(code="userManage", name="\u4fee\u6539\u7528\u6237\u5934\u50cf", permType=PermissionType.BUTTON)
    public ReturnVO verificationCode(@RequestBody AdminUserInfoCmd user) {
        if (Objects.isNull(user)) {
            return new ReturnVO(ReturnEnum.ERROR_USER_NULL);
        }
        boolean flag = this.adminUserInfoService.modifyPwdVerificationCode(user);
        if (flag) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO("201", "\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25");
    }

    @UserLog(value="\u91cd\u7f6e\u5bc6\u7801")
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801", notes="\u65e0")
    @PostMapping(value={"/resetPassword"})
    @PermissionSource(code="userManage", name="\u4fee\u6539\u7528\u6237\u5934\u50cf", permType=PermissionType.BUTTON)
    public ReturnVO resetPassword(@RequestBody AdminUserInfoCmd user) {
        if (Objects.isNull(user)) {
            return new ReturnVO(ReturnEnum.ERROR_USER_NULL);
        }
        boolean flag = this.adminUserInfoService.resettingPasswords(user);
        if (flag) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO("201", "\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25");
    }

    @UserLog(value="\u4e2a\u4eba\u4e2d\u5fc3\u4fee\u6539\u5bc6\u7801")
    @ApiOperation(value="\u4e2a\u4eba\u4e2d\u5fc3\u4fee\u6539\u5bc6\u7801", notes="\u65e0")
    @PostMapping(value={"/userUpdatePwd"})
    @PermissionSource(code="userManage", name="\u4fee\u6539\u7528\u6237\u5934\u50cf", permType=PermissionType.BUTTON)
    public ReturnVO userUpdatePwd(@RequestBody AdminUserInfoCmd user, HttpServletRequest request) {
        if (Objects.isNull(user)) {
            return new ReturnVO(ReturnEnum.ERROR_USER_NULL);
        }
        UserPasswordCmd userPasswordCmd = new UserPasswordCmd();
        this.userService.updatePassword(userPasswordCmd);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u767b\u5f55\u4fee\u6539\u5bc6\u7801")
    @ApiOperation(value="\u767b\u5f55\u4fee\u6539\u5bc6\u7801", notes="\u65e0")
    @PostMapping(value={"/updatePassword"})
    @PermissionSource(code="userManage", name="\u4fee\u6539\u7528\u6237\u5934\u50cf", permType=PermissionType.BUTTON)
    public ReturnVO updatePassword(@RequestBody AdminUserInfoCmd user, HttpServletRequest request) {
        if (Objects.isNull(user)) {
            return new ReturnVO(ReturnEnum.ERROR_USER_NULL);
        }
        boolean b = this.adminUserInfoService.updatePassword(user);
        if (b) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO("201", "\u767b\u5f55\u5bc6\u7801\u4fee\u6539\u5931\u8d25");
    }

    @UserLog(value="\u83b7\u53d6\u7528\u6237\u8be6\u60c5\u4fe1\u606f(\u5982\u679c\u6709\u6210\u5458\u4fe1\u606f\u5219\u67e5\u6210\u5458\u8868 \u6ca1\u6709\u5219\u67e5\u7528\u6237\u8868)")
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8be6\u60c5\u4fe1\u606f(\u5982\u679c\u6709\u6210\u5458\u4fe1\u606f\u5219\u67e5\u6210\u5458\u8868 \u6ca1\u6709\u5219\u67e5\u7528\u6237\u8868)", notes="\u65e0")
    @PostMapping(value={"/getUserInfo"})
    public ReturnVO<UserInfoCo> getUserInfo(@RequestBody @ApiParam(value="\u901a\u8fc7\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f", required=true) AdminUserInfoCmd adminUserInfoCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.adminUserInfoService.selectUserInfo(adminUserInfoCmd));
    }

    @UserLog(value="\u4fee\u6539\u7528\u6237\u8be6\u60c5\u4fe1\u606f(\u5982\u679c\u6709\u6210\u5458\u4fe1\u606f\u5219\u67e5\u6210\u5458\u8868 \u6ca1\u6709\u5219\u67e5\u7528\u6237\u8868)")
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u8be6\u60c5\u4fe1\u606f(\u5982\u679c\u6709\u6210\u5458\u4fe1\u606f\u5219\u67e5\u6210\u5458\u8868 \u6ca1\u6709\u5219\u67e5\u7528\u6237\u8868)", notes="\u65e0")
    @PostMapping(value={"/updateUserInfo"})
    public ReturnVO updateUserInfoBy(@RequestBody AdminUserInfoCmd adminUserInfoCmd) {
        this.adminUserInfoService.updateUserByPhone(adminUserInfoCmd);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u4fee\u6539\u7528\u6237\u5934\u50cf")
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5934\u50cf", notes="\u65e0")
    @PostMapping(value={"/uploadImg"})
    @PermissionSource(code="userManage", name="\u4fee\u6539\u7528\u6237\u5934\u50cf", permType=PermissionType.BUTTON)
    public ReturnVO uploadImg(@RequestPart(value="file") MultipartFile file) {
        if (Objects.isNull(file)) {
            return new ReturnVO(ReturnEnum.ERROR_USER_NULL);
        }
        boolean flag = this.adminUserInfoService.uploadImg(file);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }
}

