/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.cicv.foton.admin.api.IAppInfoService;
import com.cicv.foton.admin.api.IRoleService;
import com.cicv.foton.admin.domain.system.Role;
import com.cicv.foton.admin.domain.system.ServiceResource;
import com.cicv.foton.admin.domain.system.dataobject.PermInfoDO;
import com.cicv.foton.admin.dto.RoleCmd;
import com.cicv.foton.admin.dto.clientobject.RoleCO;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.PermissionType;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.permission.PermissionSource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/role"})
@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
public class RoleController {
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IAppInfoService appInfoService;

    @UserLog(value="\u65b0\u589e\u89d2\u8272\u4fe1\u606f")
    @ApiOperation(value="\u65b0\u589e\u89d2\u8272\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/addRole"})
    @PermissionSource(code="roleManage", name="\u65b0\u589e\u89d2\u8272\u4fe1\u606f", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> addRole(@Validated @RequestBody RoleCmd role) {
        return this.roleService.insertRole(role);
    }

    @UserLog(value="\u89d2\u8272\u5217\u8868")
    @ApiOperation(value="\u89d2\u8272\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/page"})
    @PermissionSource(code="roleManage", name="\u89d2\u8272\u5206\u9875\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<IPage<Role>> page(@RequestBody @ApiParam RoleCmd roleCmd) {
        IPage rolePage = this.roleService.pageRole(roleCmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)rolePage);
    }

    @UserLog(value="\u66f4\u65b0\u89d2\u8272\u4fe1\u606f")
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/updateRole"})
    @PermissionSource(code="roleManage", name="\u66f4\u65b0\u89d2\u8272\u4fe1\u606f", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> updateRole(@RequestBody RoleCmd role) {
        return this.roleService.updateRole(role);
    }

    @UserLog(value="\u5220\u9664\u89d2\u8272\u4fe1\u606f")
    @ApiOperation(value="\u5220\u9664\u89d2\u8272\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/deleteRole"})
    @PermissionSource(code="roleManage", name="\u5220\u9664\u89d2\u8272\u4fe1\u606f", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> deleteRole(@RequestBody RoleCmd roleId) {
        return this.roleService.deleteRole(roleId);
    }

    @UserLog(value="\u505c\u7528\u3001\u542f\u7528\u89d2\u8272\u4fe1\u606f")
    @ApiOperation(value="\u505c\u7528\u3001\u542f\u7528\u89d2\u8272\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/updateRoleState"})
    @PermissionSource(code="updateRoleState", name="\u505c\u7528\u3001\u542f\u7528\u89d2\u8272\u4fe1\u606f", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> updateRoleState(@RequestBody RoleCmd roleId) {
        return this.roleService.updateRoleState(roleId);
    }

    @UserLog(value="\u67e5\u770b\u89d2\u8272\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u770b\u89d2\u8272\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/selectRoleInfo"})
    @PermissionSource(code="roleManage", name="\u67e5\u770b\u89d2\u8272\u4fe1\u606f", permType=PermissionType.BUTTON)
    public ReturnVO selectRoleInfo(@RequestBody @ApiParam(value="\u89d2\u8272ID") RoleCmd cmd) {
        RoleCO role = this.roleService.selectRoleById(cmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)role);
    }

    @UserLog(value="\u89d2\u8272\u65b0\u589e-\u83b7\u53d6\u6743\u9650\u4fe1\u606f\u5217\u8868")
    @ApiOperation(value="\u89d2\u8272\u65b0\u589e-\u83b7\u53d6\u6743\u9650\u4fe1\u606f\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/applicationConfiguration"})
    @PermissionSource(code="applicationConfiguration", name="-\u83b7\u53d6\u6743\u9650\u4fe1\u606f\u5217\u8868", permType=PermissionType.BUTTON)
    public ReturnVO<List<PermInfoDO>> queryApplicationConfiguration(@RequestBody RoleCmd roleCmd) {
        List permInfos = this.appInfoService.selectPermInfoList(roleCmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)permInfos);
    }

    @UserLog(value="\u89d2\u8272\u65b0\u589e-\u70b9\u51fb\u6743\u9650\u67e5\u770b\u6743\u9650\u5217\u8868")
    @ApiOperation(value="\u89d2\u8272\u67e5\u770b-\u70b9\u51fb\u6743\u9650\u67e5\u770b\u6743\u9650\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/roleConfiguration"})
    @PermissionSource(code="roleConfiguration", name="-\u70b9\u51fb\u6743\u9650\u67e5\u770b\u6743\u9650\u5217\u8868", permType=PermissionType.BUTTON)
    public ReturnVO<List<ServiceResource>> queryRoleConfiguration(@RequestBody RoleCmd roleCmd) {
        List permInfos = this.appInfoService.roleConfiguration(roleCmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)permInfos);
    }
}

