/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.cicv.foton.admin.api.IAppInfoService;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.system.AppInfo;
import com.cicv.foton.admin.domain.system.Dict;
import com.cicv.foton.admin.domain.system.ServiceInfo;
import com.cicv.foton.admin.domain.system.ServiceResource;
import com.cicv.foton.admin.dto.AppInfoCmd;
import com.cicv.foton.admin.dto.AppInfoInsertCmd;
import com.cicv.foton.admin.dto.PermCmd;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.PermissionType;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.permission.PermissionSource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/appInfo"})
@Api(tags={"\u5e94\u7528\u7ba1\u7406"})
public class AppInfoController {
    @Autowired
    private IAppInfoService appInfoService;

    @ApiOperation(value="\u5e94\u7528\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/page"})
    @PermissionSource(code="appInfo", name="\u5e94\u7528\u5217\u8868\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<IPage<AppInfo>> page(@RequestBody @ApiParam(value="\u5e94\u7528\u5165\u53c2\u5b9e\u4f53") AppInfoCmd appInfoCmd) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.appInfoService.pageList(appInfoCmd));
    }

    @ApiOperation(value="\u65b0\u589e\u6ce8\u518c\u5e94\u7528", notes="\u65e0")
    @PostMapping(value={"/add"})
    @PermissionSource(code="appInfo", name="\u65b0\u589e\u6ce8\u518c\u5e94\u7528", permType=PermissionType.BUTTON)
    @Transactional
    public ReturnVO<Boolean> add(@RequestBody @ApiParam(value="\u5e94\u7528\u5165\u53c2\u5b9e\u4f53") AppInfoInsertCmd appInfoCmd) {
        return this.appInfoService.addAppInfo(appInfoCmd);
    }

    @UserLog(value="\u5e94\u7528\u8be6\u60c5")
    @ApiOperation(value="\u5e94\u7528\u8be6\u60c5", notes="\u65e0")
    @GetMapping(value={"/getAppInfo/{id}"})
    @PermissionSource(code="appInfo", name="\u5e94\u7528\u8be6\u60c5", permType=PermissionType.BUTTON)
    public ReturnVO<AppInfoCmd> getAppInfoById(@PathVariable(value="id") @ApiParam(value="id") Long id) {
        AppInfoCmd appInfoCmd = new AppInfoCmd();
        appInfoCmd.setId(id);
        return this.appInfoService.getAppInfoById(appInfoCmd);
    }

    @UserLog(value="\u66f4\u65b0\u5e94\u7528")
    @ApiOperation(value="\u66f4\u65b0\u5e94\u7528", notes="\u65e0")
    @PostMapping(value={"/update"})
    @PermissionSource(code="appInfo", name="\u66f4\u65b0\u5e94\u7528", permType=PermissionType.BUTTON)
    @Transactional
    public ReturnVO<Boolean> update(@RequestBody @ApiParam(value="\u5e94\u7528\u5165\u53c2\u5b9e\u4f53") AppInfoCmd appInfoCmd) {
        return this.appInfoService.updateAppInfo(appInfoCmd);
    }

    @UserLog(value="\u5220\u9664\u5e94\u7528")
    @ApiOperation(value="\u5220\u9664\u5e94\u7528", notes="\u65e0")
    @GetMapping(value={"/deleteById/{id}"})
    @PermissionSource(code="appInfo", name="\u5220\u9664\u5e94\u7528", permType=PermissionType.BUTTON)
    public ReturnVO deleteById(@PathVariable(value="id") @ApiParam(value="\u5e94\u7528id") Long id) {
        AppInfoCmd appInfoCmd = new AppInfoCmd();
        appInfoCmd.setId(id);
        return this.appInfoService.deleteById(appInfoCmd);
    }

    @UserLog(value="\u4e0a\u4e0b\u67b6\u5e94\u7528")
    @ApiOperation(value="\u4e0a\u4e0b\u67b6\u5e94\u7528", notes="\u65e0")
    @PostMapping(value={"/updateAppStatus"})
    @PermissionSource(code="appInfo", name="\u4e0a\u4e0b\u67b6\u5e94\u7528", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> updateAppStatus(@RequestBody @ApiParam(value="\u5e94\u7528id") AppInfoCmd appInfoId) {
        return this.appInfoService.updateAppStatus(appInfoId);
    }

    @UserLog(value="\u914d\u7f6e\u670d\u52a1")
    @ApiOperation(value="\u914d\u7f6e\u670d\u52a1", notes="\u65e0")
    @PostMapping(value={"/getConfigurationService"})
    @PermissionSource(code="getConfigurationService", name="\u914d\u7f6e\u670d\u52a1", permType=PermissionType.BUTTON)
    public ReturnVO<List<ServiceInfo>> getConfigurationService(@RequestBody @ApiParam(value="\u914d\u7f6e\u670d\u52a1") AppInfoCmd appInfoCmd) {
        return this.appInfoService.queryConfigurationService(appInfoCmd);
    }

    @UserLog(value="\u6743\u9650\u914d\u7f6e")
    @ApiOperation(value="\u6743\u9650\u914d\u7f6e", notes="\u65e0")
    @PostMapping(value={"/addPermissions"})
    @PermissionSource(code="addPermissions", name="\u6743\u9650\u914d\u7f6e", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> addPermissions(@RequestBody PermCmd permCmd) {
        return this.appInfoService.insertPermissions(permCmd);
    }

    @UserLog(value="\u83b7\u53d6\u83dc\u5355")
    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355", notes="\u65e0")
    @GetMapping(value={"/getMenuInformation/{id}"})
    @PermissionSource(code="getMenuInformation", name="\u83b7\u53d6\u83dc\u5355", permType=PermissionType.BUTTON)
    public ReturnVO<List<ServiceResource>> getMenuInformation(@PathVariable(value="id") @ApiParam(value="id") Long id) {
        PermCmd permCmd = new PermCmd();
        permCmd.setSrvId(id);
        permCmd.setMenuType(Constant.MENU_TYPE);
        List menuInformation = this.appInfoService.getMenuInformation(permCmd);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)menuInformation);
    }

    @UserLog(value="\u83b7\u53d6\u83dc\u5355")
    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355", notes="\u65e0")
    @GetMapping(value={"/getMenuInfo"})
    @PermissionSource(code="getMenuInfo", name="\u83b7\u53d6\u83dc\u5355", permType=PermissionType.BUTTON)
    public ReturnVO<List<Dict>> getMenuInfo() {
        List menuInformation = this.appInfoService.getMenuInfo();
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)menuInformation);
    }
}

