/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import com.cicv.foton.admin.api.IAdminOrgService;
import com.cicv.foton.admin.domain.system.AdminOrg;
import com.cicv.foton.admin.dto.AdminOrgDetailCmd;
import com.cicv.foton.admin.dto.AdminOrgInfoCmd;
import com.cicv.foton.admin.dto.AdminOrgListCmd;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/org"})
@Api(tags={"\u7ec4\u7ec7\u673a\u6784\u7ba1\u7406"})
public class AdminOrgController {
    @Resource
    private IAdminOrgService iAdminOrgService;

    @UserLog(value="\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7\u673a\u6784\u540d\u79f0")
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7\u673a\u6784\u540d\u79f0")
    @GetMapping(value={"/queryAllOrg"})
    public ReturnVO<List<AdminOrg>> queryAllOrg() {
        List adminOrgList = this.iAdminOrgService.queryAllOrg();
        return new ReturnVO((Object)adminOrgList);
    }

    @UserLog(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u6811")
    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u6811")
    @PostMapping(value={"/listTree"})
    public ReturnVO<List<AdminOrg>> queryOrgListTree(@RequestBody AdminOrgListCmd adminOrgListCmd) {
        List adminOrgList = this.iAdminOrgService.queryOrgListTree(adminOrgListCmd);
        return new ReturnVO((Object)adminOrgList);
    }

    @UserLog(value="\u65b0\u589e\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u65b0\u589e\u7ec4\u7ec7\u673a\u6784")
    @PostMapping(value={"/saveOrg"})
    public ReturnVO<Boolean> saveOrg(@Validated @RequestBody AdminOrgInfoCmd adminOrgInfoCmd) {
        Boolean flag = this.iAdminOrgService.saveOrg(adminOrgInfoCmd);
        if (flag.booleanValue()) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u65b0\u589e\u5931\u8d25");
    }

    @UserLog(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u8be6\u60c5")
    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u8be6\u60c5")
    @PostMapping(value={"/queryDetail"})
    public ReturnVO<AdminOrgDetailCmd> queryDetail(@RequestParam(value="id") Long id) {
        AdminOrgDetailCmd adminOrgDetailCmd = this.iAdminOrgService.queryDetail(id);
        return new ReturnVO((Object)adminOrgDetailCmd);
    }

    @UserLog(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784")
    @PostMapping(value={"/updateOrg"})
    public ReturnVO<Boolean> updateOrg(@RequestBody AdminOrgInfoCmd adminOrgInfoCmd) {
        Boolean flag = this.iAdminOrgService.updateOrg(adminOrgInfoCmd);
        if (flag.booleanValue()) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u4fee\u6539\u5931\u8d25");
    }

    @UserLog(value="\u5220\u9664\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u5220\u9664\u7ec4\u7ec7\u673a\u6784")
    @PostMapping(value={"/deleteOrg"})
    public ReturnVO<Boolean> deleteOrg(@RequestParam(value="id") Long id) {
        Boolean flag = this.iAdminOrgService.deleteOrg(id);
        if (flag.booleanValue()) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u5220\u9664\u5931\u8d25");
    }

    @UserLog(value="\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u63d0\u793a")
    @ApiOperation(value="\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u63d0\u793a")
    @PostMapping(value={"/deleteOrgTips"})
    public ReturnVO deleteOrgTips(@RequestParam(value="id") Long id) {
        return this.iAdminOrgService.deleteOrgTips(id);
    }

    @UserLog(value="\u67e5\u8be2\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u67e5\u8be2\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784")
    @PostMapping(value={"/queryChildOrg"})
    public ReturnVO<List<AdminOrg>> queryChildOrg(@RequestParam(value="id") Long id) {
        List adminOrgList = this.iAdminOrgService.queryChildOrg(id);
        return new ReturnVO((Object)adminOrgList);
    }

    @UserLog(value="\u67e5\u8be2\u6240\u6709\u90e8\u95e8\u7b49\u7ea7")
    @ApiOperation(value="\u67e5\u8be2\u90e8\u95e8\u7b49\u7ea7")
    @PostMapping(value={"/queryAllLevel"})
    public ReturnVO<Set<Integer>> queryAllLevel() {
        Set levelList = this.iAdminOrgService.queryAllLevel();
        return new ReturnVO((Object)levelList);
    }
}

