/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import com.cicv.foton.admin.api.IMenuIconService;
import com.cicv.foton.admin.api.IMenuService;
import com.cicv.foton.admin.domain.system.Menu;
import com.cicv.foton.admin.domain.system.MenuIcon;
import com.cicv.foton.admin.dto.MenuCmd;
import com.cicv.foton.admin.dto.clientobject.MenuCo;
import com.cicv.foton.admin.dto.clientobject.MenuIds;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.PermissionType;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.permission.PermissionSource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/menu"})
@Api(tags={"\u7cfb\u7edf\u83dc\u5355\u7ba1\u7406"})
public class MenuController {
    @Autowired
    private IMenuService menuService;
    @Autowired
    private IMenuIconService iconService;

    @UserLog(value="\u83b7\u53d6\u83dc\u5355\u8be6\u60c5")
    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u8be6\u60c5", notes="\u65e0")
    @PostMapping(value={"/get"})
    @PermissionSource(code="menuManage", name="\u83dc\u5355\u67e5\u8be2", permType=PermissionType.BUTTON)
    public ReturnVO<Menu> getMenu(@RequestParam @ApiParam(value="\u83dc\u5355ID") Long id) {
        MenuCmd menuCmd = new MenuCmd();
        menuCmd.setId(id);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.menuService.getByOne(menuCmd));
    }

    @UserLog(value="\u65b0\u589e\u83dc\u5355")
    @ApiOperation(value="\u65b0\u589e\u83dc\u5355", notes="\u65e0")
    @PostMapping(value={"/add"})
    @Transactional
    @PermissionSource(code="menuManage", name="\u6dfb\u52a0\u83dc\u5355", permType=PermissionType.BUTTON)
    public ReturnVO<Void> addMenu(@Validated @RequestBody @ApiParam(value="\u83dc\u5355") MenuCmd menuCmd) {
        Menu menu = new Menu();
        BeanUtils.copyProperties((Object)menuCmd, (Object)menu);
        menu.setMenuType(Integer.valueOf(menuCmd.getMenuType()));
        if (this.menuService.queryRepetition(menu).booleanValue()) {
            return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u5df2\u6709\u76f8\u540c\u83dc\u5355\u9879\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
        }
        menu.setCode(UUID.randomUUID().toString().replaceAll("-", ""));
        menu.setId(null);
        if (Objects.isNull(menu.getParentId())) {
            menu.setParentId(Long.valueOf(0L));
        }
        this.menuService.saveOne(menu);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u4fee\u6539\u83dc\u5355")
    @ApiOperation(value="\u4fee\u6539\u83dc\u5355", notes="\u65e0")
    @PostMapping(value={"/update"})
    @Transactional
    @PermissionSource(code="menuManage", name="\u7f16\u8f91\u83dc\u5355", permType=PermissionType.BUTTON)
    public ReturnVO<Void> updateMenu(@Validated @RequestBody @ApiParam(value="\u83dc\u5355") MenuCmd menuCmd) {
        Menu menu = new Menu();
        BeanUtils.copyProperties((Object)menuCmd, (Object)menu);
        menu.setMenuType(Integer.valueOf(menuCmd.getMenuType()));
        if (this.menuService.queryRepetition(menu).booleanValue()) {
            return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u5df2\u6709\u76f8\u540c\u83dc\u5355\u9879\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
        }
        this.menuService.updateOne(menu);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u6279\u91cf\u5220\u9664\u83dc\u5355")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u83dc\u5355", notes="\u65e0")
    @PostMapping(value={"/delete"})
    @Transactional
    @PermissionSource(code="menuManage", name="\u5220\u9664\u83dc\u5355", permType=PermissionType.BUTTON)
    public ReturnVO<Void> deleteMenu(@RequestBody @ApiParam(value="\u83dc\u5355ID") MenuIds menuIds) {
        MenuCmd menuCmd = new MenuCmd();
        menuCmd.setMenuIds(menuIds);
        this.menuService.removeMenusByIds(menuCmd);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u67e5\u8be2\u83dc\u5355\u76ee\u5f55\u6811")
    @ApiOperation(value="\u67e5\u8be2\u83dc\u5355\u76ee\u5f55\u6811", notes="\u65e0")
    @PostMapping(value={"/trees"})
    @PermissionSource(code="menuManage", name="\u83dc\u5355\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<MenuCo>> queryTrees() {
        List trees = this.menuService.queryTrees();
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)trees);
    }

    @UserLog(value="\u67e5\u8be2\u83dc\u5355\u7684icon\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u83dc\u5355\u7684icon\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/getIconList"})
    @PermissionSource(code="menuManage", name="\u83dc\u5355\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<MenuIcon>> getIconList() {
        List list = this.iconService.queryList();
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)list);
    }
}

