/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins;

import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class OptimisticLockerInterceptor
implements Interceptor {
    public static final String MP_OPTLOCK_VERSION_ORIGINAL = "MP_OPTLOCK_VERSION_ORIGINAL";
    public static final String MP_OPTLOCK_VERSION_COLUMN = "MP_OPTLOCK_VERSION_COLUMN";
    public static final String MP_OPTLOCK_ET_ORIGINAL = "MP_OPTLOCK_ET_ORIGINAL";
    private static final String NAME_ENTITY = "et";
    private static final String NAME_ENTITY_WRAPPER = "ew";
    private static final String PARAM_UPDATE_METHOD_NAME = "update";
    private final Map<Class<?>, EntityField> versionFieldCache = new ConcurrentHashMap();
    private final Map<Class<?>, List<EntityField>> entityFieldsCache = new ConcurrentHashMap();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (SqlCommandType.UPDATE != ms.getSqlCommandType()) {
            return invocation.proceed();
        }
        Object param = args[1];
        Wrapper ew = null;
        Object et = null;
        if (param instanceof Map) {
            Map map = (Map)param;
            if (map.containsKey(NAME_ENTITY)) {
                et = map.get(NAME_ENTITY);
            }
            if (map.containsKey(NAME_ENTITY_WRAPPER)) {
                ew = (Wrapper)map.get(NAME_ENTITY_WRAPPER);
            }
            if (et != null) {
                String methodId = ms.getId();
                String updateMethodName = methodId.substring(ms.getId().lastIndexOf(".") + 1);
                Class entityClass = et.getClass();
                TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
                while (tableInfo == null && entityClass != null) {
                    entityClass = ClassUtils.getUserClass(entityClass.getSuperclass());
                    tableInfo = TableInfoHelper.getTableInfo((Class)entityClass);
                }
                EntityField entityVersionField = this.getVersionField(entityClass, tableInfo);
                if (entityVersionField == null) {
                    return invocation.proceed();
                }
                Field versionField = entityVersionField.getField();
                Object originalVersionVal = entityVersionField.getField().get(et);
                Object updatedVersionVal = this.getUpdatedVersionVal(originalVersionVal);
                if (PARAM_UPDATE_METHOD_NAME.equals(updateMethodName)) {
                    if (originalVersionVal != null) {
                        if (ew == null) {
                            QueryWrapper aw = new QueryWrapper();
                            aw.eq((Object)entityVersionField.getColumnName(), originalVersionVal);
                            map.put(NAME_ENTITY_WRAPPER, aw);
                            versionField.set(et, updatedVersionVal);
                        } else if (ew instanceof AbstractWrapper) {
                            AbstractWrapper aw = (AbstractWrapper)ew;
                            aw.eq((Object)entityVersionField.getColumnName(), originalVersionVal);
                            versionField.set(et, updatedVersionVal);
                        }
                    }
                    return invocation.proceed();
                }
                this.dealUpdateById(entityClass, et, entityVersionField, originalVersionVal, updatedVersionVal, map);
                Object resultObj = invocation.proceed();
                if (resultObj instanceof Integer) {
                    Integer effRow = (Integer)resultObj;
                    if (updatedVersionVal != null && effRow != 0 && versionField != null) {
                        versionField.set(et, updatedVersionVal);
                    }
                }
                return resultObj;
            }
        }
        return invocation.proceed();
    }

    private void dealUpdateById(Class<?> entityClass, Object et, EntityField entityVersionField, Object originalVersionVal, Object updatedVersionVal, Map map) throws IllegalAccessException {
        if (originalVersionVal == null) {
            return;
        }
        List<EntityField> fields = this.getEntityFields(entityClass);
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        for (EntityField ef : fields) {
            Field fd = ef.getField();
            entityMap.put(fd.getName(), fd.get(et));
        }
        Field versionField = entityVersionField.getField();
        String versionColumnName = entityVersionField.getColumnName();
        entityVersionField.setColumnName(versionColumnName);
        entityMap.put(versionField.getName(), updatedVersionVal);
        entityMap.put(MP_OPTLOCK_VERSION_ORIGINAL, originalVersionVal);
        entityMap.put(MP_OPTLOCK_VERSION_COLUMN, versionColumnName);
        entityMap.put(MP_OPTLOCK_ET_ORIGINAL, et);
        map.put(NAME_ENTITY, entityMap);
    }

    protected Object getUpdatedVersionVal(Object originalVersionVal) {
        if (null == originalVersionVal) {
            return null;
        }
        Class<?> versionValClass = originalVersionVal.getClass();
        if (Long.TYPE.equals(versionValClass)) {
            return (Long)originalVersionVal + 1L;
        }
        if (Long.class.equals(versionValClass)) {
            return (Long)originalVersionVal + 1L;
        }
        if (Integer.TYPE.equals(versionValClass)) {
            return (Integer)originalVersionVal + 1;
        }
        if (Integer.class.equals(versionValClass)) {
            return (Integer)originalVersionVal + 1;
        }
        if (Date.class.equals(versionValClass)) {
            return new Date();
        }
        if (Timestamp.class.equals(versionValClass)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (LocalDateTime.class.equals(versionValClass)) {
            return LocalDateTime.now();
        }
        return originalVersionVal;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityField getVersionField(Class<?> parameterClass, TableInfo tableInfo) {
        String string = parameterClass.getName();
        synchronized (string) {
            if (this.versionFieldCache.containsKey(parameterClass)) {
                return this.versionFieldCache.get(parameterClass);
            }
            EntityField field = this.getVersionFieldRegular(parameterClass, tableInfo);
            if (field != null) {
                this.versionFieldCache.put(parameterClass, field);
                return field;
            }
            return null;
        }
    }

    private EntityField getVersionFieldRegular(Class<?> parameterClass, TableInfo tableInfo) {
        if (parameterClass != Object.class) {
            for (Field field : parameterClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Version.class)) continue;
                field.setAccessible(true);
                String versionPropertyName = field.getName();
                String versionColumnName = null;
                for (TableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                    if (!versionPropertyName.equals(fieldInfo.getProperty())) continue;
                    versionColumnName = fieldInfo.getColumn();
                }
                return new EntityField(field, true, versionColumnName);
            }
            return this.getVersionFieldRegular(parameterClass.getSuperclass(), tableInfo);
        }
        return null;
    }

    private List<EntityField> getEntityFields(Class<?> parameterClass) {
        if (this.entityFieldsCache.containsKey(parameterClass)) {
            return this.entityFieldsCache.get(parameterClass);
        }
        List<EntityField> fields = this.getFieldsFromClazz(parameterClass, null);
        this.entityFieldsCache.put(parameterClass, fields);
        return fields;
    }

    private List<EntityField> getFieldsFromClazz(Class<?> parameterClass, List<EntityField> fieldList) {
        if (fieldList == null) {
            fieldList = new ArrayList<EntityField>();
        }
        List fields = ReflectionKit.getFieldList(parameterClass);
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(Version.class)) {
                fieldList.add(new EntityField(field, true));
                continue;
            }
            fieldList.add(new EntityField(field, false));
        }
        return fieldList;
    }

    private class EntityField {
        private Field field;
        private boolean version;
        private String columnName;

        EntityField(Field field, boolean version) {
            this.field = field;
            this.version = version;
        }

        public EntityField(Field field, boolean version, String columnName) {
            this.field = field;
            this.version = version;
            this.columnName = columnName;
        }

        public Field getField() {
            return this.field;
        }

        public boolean isVersion() {
            return this.version;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public void setVersion(boolean version) {
            this.version = version;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityField)) {
                return false;
            }
            EntityField other = (EntityField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Field this$field = this.getField();
            Field other$field = other.getField();
            if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
                return false;
            }
            if (this.isVersion() != other.isVersion()) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntityField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Field $field = this.getField();
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            result = result * 59 + (this.isVersion() ? 79 : 97);
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            return result;
        }

        public String toString() {
            return "OptimisticLockerInterceptor.EntityField(field=" + this.getField() + ", version=" + this.isVersion() + ", columnName=" + this.getColumnName() + ")";
        }
    }
}

