/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.hikari.HikariCpConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.springframework.util.StringUtils;

public class HikariDataSourceCreator
implements DataSourceCreator {
    private static Boolean hikariExists = false;
    private static Method configCopyMethod = null;
    private HikariCpConfig gConfig;

    private static void fetchMethod() {
        try {
            configCopyMethod = HikariConfig.class.getMethod("copyState", HikariConfig.class);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                configCopyMethod = HikariConfig.class.getMethod("copyStateTo", HikariConfig.class);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("HikariConfig does not has 'copyState' or 'copyStateTo' method!");
            }
        }
    }

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        HikariConfig config = dataSourceProperty.getHikari().toHikariConfig(this.gConfig);
        config.setUsername(dataSourceProperty.getUsername());
        config.setPassword(dataSourceProperty.getPassword());
        config.setJdbcUrl(dataSourceProperty.getUrl());
        config.setPoolName(dataSourceProperty.getPoolName());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (!StringUtils.isEmpty((Object)driverClassName)) {
            config.setDriverClassName(driverClassName);
        }
        if (!dataSourceProperty.getLazy().booleanValue()) {
            return new HikariDataSource(config);
        }
        config.validate();
        HikariDataSource dataSource = new HikariDataSource();
        try {
            configCopyMethod.invoke((Object)config, dataSource);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("HikariConfig failed to copy to HikariDataSource", e);
        }
        return dataSource;
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null && hikariExists != false || type != null && "com.zaxxer.hikari.HikariDataSource".equals(type.getName());
    }

    public HikariCpConfig getGConfig() {
        return this.gConfig;
    }

    public void setGConfig(HikariCpConfig gConfig) {
        this.gConfig = gConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HikariDataSourceCreator)) {
            return false;
        }
        HikariDataSourceCreator other = (HikariDataSourceCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HikariCpConfig this$gConfig = this.getGConfig();
        HikariCpConfig other$gConfig = other.getGConfig();
        return !(this$gConfig == null ? other$gConfig != null : !((Object)this$gConfig).equals(other$gConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HikariDataSourceCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HikariCpConfig $gConfig = this.getGConfig();
        result = result * 59 + ($gConfig == null ? 43 : ((Object)$gConfig).hashCode());
        return result;
    }

    public String toString() {
        return "HikariDataSourceCreator(gConfig=" + this.getGConfig() + ")";
    }

    public HikariDataSourceCreator(HikariCpConfig gConfig) {
        this.gConfig = gConfig;
    }

    static {
        try {
            Class.forName("com.zaxxer.hikari.HikariDataSource");
            hikariExists = true;
            HikariDataSourceCreator.fetchMethod();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

