/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.eiptp;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.eiptp.model.CreateEipTpRequest;
import com.baidubce.services.eiptp.model.CreateEipTpResponse;
import com.baidubce.services.eiptp.model.EipTpDetailResponse;
import com.baidubce.services.eiptp.model.GetEipTpRequest;
import com.baidubce.services.eiptp.model.ListEipTpsRequest;
import com.baidubce.services.eiptp.model.ListEipTpsResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;

public class EipTpClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PREFIX = "eiptp";
    private static final String CLIENT_TOKEN_IDENTIFY = "clientToken";
    private static HttpResponseHandler[] eipHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public EipTpClient() {
        this(new BceClientConfiguration());
    }

    public EipTpClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, eipHandlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        path.add(PREFIX);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateDefaultClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateEipTpResponse createEipTp(CreateEipTpRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkNotNull(request.getReservationLength(), "reservationLength should not be null.");
        Validate.checkStringNotEmpty(request.getCapacity(), "capacity should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateEipTpResponse.class);
    }

    public EipTpDetailResponse getEipTpDetail(GetEipTpRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkNotNull(request.getId(), "id should not be blank!");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, request.getId());
        return this.invokeHttpClient(internalRequest, EipTpDetailResponse.class);
    }

    public EipTpDetailResponse getEipTpDetail(String id) {
        GetEipTpRequest getEipTpRequest = new GetEipTpRequest();
        getEipTpRequest.setId(id);
        return this.getEipTpDetail(getEipTpRequest);
    }

    public ListEipTpsResponse listEipTps(ListEipTpsRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, null);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0 && request.getMaxKeys() <= 1000) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getId())) {
            internalRequest.addParameter("id", request.getId());
        }
        if (!Strings.isNullOrEmpty((String)request.getDeductPolicy())) {
            internalRequest.addParameter("deductPolicy", request.getDeductPolicy());
        }
        if (!Strings.isNullOrEmpty((String)request.getStatus())) {
            internalRequest.addParameter("status", request.getStatus());
        }
        return this.invokeHttpClient(internalRequest, ListEipTpsResponse.class);
    }

    public ListEipTpsResponse listEipTps() {
        ListEipTpsRequest request = new ListEipTpsRequest();
        return this.listEipTps(request);
    }
}

