/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.demo;

import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.baidubce.services.bos.model.PutObjectResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class PutObjectDemo {
    public static void putObjectSimple() throws FileNotFoundException {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        File file = new File("/path/to/file.zip");
        FileInputStream inputStream = new FileInputStream("/path/to/test.zip");
        byte[] byte0 = new byte[]{};
        PutObjectResponse putObjectFromFileResponse = client.putObject("bucketName", "file-objectKey", file);
        PutObjectResponse putObjectResponseFromInputStream = client.putObject("bucketName", "inputStream-objectKey", inputStream);
        PutObjectResponse putObjectResponseFromByte = client.putObject("bucketName", "byte-objectKey", byte0);
        PutObjectResponse putObjectResponseFromString = client.putObject("bucketName", "string-objectKey", "hello world");
        System.out.println(putObjectFromFileResponse.getETag());
        System.out.println(putObjectResponseFromInputStream.getETag());
        System.out.println(putObjectResponseFromByte.getETag());
        System.out.println(putObjectResponseFromString.getETag());
        client.shutdown();
    }

    public static void putObjectWithMeta() {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        File file = new File("/path/to/file.zip");
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentLength(1000L);
        meta.setContentType("application/json");
        meta.setCacheControl("no-cache");
        meta.setxBceCrc("crc");
        meta.addUserMetadata("name", "my-data");
        client.putObject("bucketName", "objectKey", file, meta);
        client.shutdown();
    }
}

