/*
 * Copyright (C) 2020 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.iotdmp.model.platform;

import com.baidubce.model.GenericAccountRequest;
import lombok.Data;

@Data
public class ListRuleChainDestinationRequest extends GenericAccountRequest {

    private String sourceType;
    private String type = "";
    private String region = "default";
    private String order;
    private String orderBy;
    private int pageNo = 1;
    private int pageSize = 10;

    public ListRuleChainDestinationRequest(String sourceType) {
        this.sourceType = sourceType;
        setOrderBy("createTime");
        setOrder("desc");
    }
}
