/*
 * Copyright (c) 2020 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.bcc.model.instance;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for get price
 */
public class BccPriceRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     * When creating the storage optimized instance, one ephemeral disk must be created together.
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The instance of specId.
     */
    private String specId;

    /**
     * The instance of spec.
     */
    private String spec;

    /**
     * the name of available zone
     */
    private String zoneName;

    /**
     * The pay time of the payment.
     */
    private String paymentTiming;

    /**
     * The length of purchase to buy, the default value is 1.
     */
    private int purchaseLength = 1;

    /**
     * The number of instance to buy, the default value is 1.
     */
    private int purchaseCount = 1;

    /**
     * Configure optional client token for the request. The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     *
     * @param clientToken An ASCII string whose length is less than 64.
     *                    See more detail at
     *                    <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *                        BCE API doc</a>
     * @return CreateInstanceRequest with specific clientToken
     */
    public BccPriceRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public BccPriceRequest withSpecId(String specId) {
        this.setSpecId(specId);
        return this;
    }

    public String getSpecId() {
        return specId;
    }

    public void setSpecId(String specId) {
        this.specId = specId;
    }

    public BccPriceRequest withSpec(String spec) {
        this.setSpec(spec);
        return this;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public BccPriceRequest withZoneName(String zoneName) {
        this.setZoneName(zoneName);
        return this;
    }

    public String getZoneName() {
        return zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public BccPriceRequest withPaymentTiming(String paymentTiming) {
        this.setPaymentTiming(paymentTiming);
        return this;
    }

    public String getPaymentTiming() {
        return paymentTiming;
    }

    public void setPaymentTiming(String paymentTiming) {
        this.paymentTiming = paymentTiming;
    }

    public BccPriceRequest withPurchaseLength(int purchaseLength) {
        this.setPurchaseLength(purchaseLength);
        return this;
    }

    public int getPurchaseLength() {
        return purchaseLength;
    }

    public void setPurchaseLength(int purchaseLength) {
        this.purchaseLength = purchaseLength;
    }

    public BccPriceRequest withPurchaseCount(int purchaseCount) {
        this.setPurchaseCount(purchaseCount);
        return this;
    }

    public int getPurchaseCount() {
        return purchaseCount;
    }

    public void setPurchaseCount(int purchaseCount) {
        this.purchaseCount = purchaseCount;
    }

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return CreateInstanceRequest with credentials.
     */
    public BccPriceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
