/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.contentcensor;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.contentcensor.ContentCensorConsts;
import com.baidu.aip.contentcensor.EImgType;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.ImageUtil;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class AipContentCensor
extends BaseClient {
    public AipContentCensor(String appId, String aipKey, String aipToken) {
        super(appId, aipKey, aipToken);
    }

    public JSONObject report(JSONArray reportData) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("feedback", reportData);
        request.setUri("https://aip.baidubce.com/rpc/2.0/feedback/v1/report");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        request.addHeader("Content-Type", "application/json");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject imageCensorUserDefined(String image, EImgType type, HashMap<String, String> options) {
        if (type == EImgType.FILE) {
            try {
                byte[] imgData = Util.readFileByBytes(image);
                return this.imageCensorUserDefined(imgData, options);
            }
            catch (IOException e) {
                return AipError.IMAGE_READ_ERROR.toJsonResult();
            }
        }
        AipRequest request = new AipRequest();
        request.addBody("imgUrl", image);
        return this.imageCensorUserDefinedHelper(request, options);
    }

    public JSONObject imageCensorUserDefined(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        return this.imageCensorUserDefinedHelper(request, options);
    }

    private JSONObject imageCensorUserDefinedHelper(AipRequest request, HashMap<String, String> options) {
        this.preOperation(request);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/img_censor/v2/user_defined");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject textCensorUserDefined(String text) {
        AipRequest request = new AipRequest();
        request.addBody("text", text);
        return this.textCensorUserDefinedHelper(request, null);
    }

    private JSONObject textCensorUserDefinedHelper(AipRequest request, HashMap<String, String> options) {
        this.preOperation(request);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/text_censor/v2/user_defined");
        this.postOperation(request);
        return this.requestServer(request);
    }

    private JSONObject checkParam(byte[] imgData) {
        String format = ImageUtil.getImageFormatByBytes(imgData);
        if (!ContentCensorConsts.ANTIPORN_SUPPORT_IMAGE_FORMAT.contains(format)) {
            return AipError.UNSUPPORTED_IMAGE_FORMAT_ERROR.toJsonResult();
        }
        return AipError.SUCCESS.toJsonResult();
    }

    private JSONObject checkImgFormat(byte[] imgData, String format) {
        String realFormat = ImageUtil.getImageFormatByBytes(imgData);
        if (realFormat.equals(format)) {
            return AipError.SUCCESS.toJsonResult();
        }
        return AipError.UNSUPPORTED_IMAGE_FORMAT_ERROR.toJsonResult();
    }

    public JSONObject voiceUrlCensorUserDefined(String url, Integer rate, String fmt, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        request.addBody("url", url);
        request.addBody("fmt", fmt);
        request.addBody("rate", rate);
        return this.voiceCensorUserDefinedHelper(request, options);
    }

    public JSONObject voiceCensorUserDefined(byte[] voiceData, Integer rate, String fmt, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        String base64Content = Base64Util.encode(voiceData);
        request.addBody("base64", base64Content);
        request.addBody("fmt", fmt);
        request.addBody("rate", rate);
        return this.voiceCensorUserDefinedHelper(request, options);
    }

    private JSONObject voiceCensorUserDefinedHelper(AipRequest request, HashMap<String, String> options) {
        this.preOperation(request);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/voice_censor/v3/user_defined");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject videoCensorUserDefined(String name, String videoUrl, String extId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        request.addBody("name", name);
        request.addBody("videoUrl", videoUrl);
        request.addBody("extId", extId);
        return this.videoCensorUserDefinedHelper(request, options);
    }

    private JSONObject videoCensorUserDefinedHelper(AipRequest request, HashMap<String, String> options) {
        this.preOperation(request);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/video_censor/v2/user_defined");
        this.postOperation(request);
        return this.requestServer(request);
    }
}

