/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.fluent.models.BackendAddressPoolInner;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.InboundNatRuleInner;
import com.azure.resourcemanager.network.fluent.models.LoadBalancerPropertiesFormat;
import com.azure.resourcemanager.network.fluent.models.LoadBalancingRuleInner;
import com.azure.resourcemanager.network.fluent.models.OutboundRuleInner;
import com.azure.resourcemanager.network.fluent.models.ProbeInner;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.InboundNatPool;
import com.azure.resourcemanager.network.models.LoadBalancerSku;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class LoadBalancerInner
extends Resource {
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="sku")
    private LoadBalancerSku sku;
    @JsonProperty(value="properties")
    private LoadBalancerPropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public LoadBalancerInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public LoadBalancerSku sku() {
        return this.sku;
    }

    public LoadBalancerInner withSku(LoadBalancerSku sku) {
        this.sku = sku;
        return this;
    }

    private LoadBalancerPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public LoadBalancerInner withId(String id) {
        this.id = id;
        return this;
    }

    public LoadBalancerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public LoadBalancerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<FrontendIpConfigurationInner> frontendIpConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendIpConfigurations();
    }

    public LoadBalancerInner withFrontendIpConfigurations(List<FrontendIpConfigurationInner> frontendIpConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withFrontendIpConfigurations(frontendIpConfigurations);
        return this;
    }

    public List<BackendAddressPoolInner> backendAddressPools() {
        return this.innerProperties() == null ? null : this.innerProperties().backendAddressPools();
    }

    public LoadBalancerInner withBackendAddressPools(List<BackendAddressPoolInner> backendAddressPools) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withBackendAddressPools(backendAddressPools);
        return this;
    }

    public List<LoadBalancingRuleInner> loadBalancingRules() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancingRules();
    }

    public LoadBalancerInner withLoadBalancingRules(List<LoadBalancingRuleInner> loadBalancingRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withLoadBalancingRules(loadBalancingRules);
        return this;
    }

    public List<ProbeInner> probes() {
        return this.innerProperties() == null ? null : this.innerProperties().probes();
    }

    public LoadBalancerInner withProbes(List<ProbeInner> probes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withProbes(probes);
        return this;
    }

    public List<InboundNatRuleInner> inboundNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundNatRules();
    }

    public LoadBalancerInner withInboundNatRules(List<InboundNatRuleInner> inboundNatRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withInboundNatRules(inboundNatRules);
        return this;
    }

    public List<InboundNatPool> inboundNatPools() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundNatPools();
    }

    public LoadBalancerInner withInboundNatPools(List<InboundNatPool> inboundNatPools) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withInboundNatPools(inboundNatPools);
        return this;
    }

    public List<OutboundRuleInner> outboundRules() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundRules();
    }

    public LoadBalancerInner withOutboundRules(List<OutboundRuleInner> outboundRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withOutboundRules(outboundRules);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

