/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.resourcemanager.datafactory.fluent.models.AvroDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Avro")
public final class AvroDataset
extends Dataset {
    @JsonProperty(value="typeProperties")
    private AvroDatasetTypeProperties innerTypeProperties;

    private AvroDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AvroDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AvroDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public AvroDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public AvroDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AvroDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AvroDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public AvroDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public DatasetLocation location() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().location();
    }

    public AvroDataset withLocation(DatasetLocation location) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AvroDatasetTypeProperties();
        }
        this.innerTypeProperties().withLocation(location);
        return this;
    }

    public Object avroCompressionCodec() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().avroCompressionCodec();
    }

    public AvroDataset withAvroCompressionCodec(Object avroCompressionCodec) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AvroDatasetTypeProperties();
        }
        this.innerTypeProperties().withAvroCompressionCodec(avroCompressionCodec);
        return this;
    }

    public Integer avroCompressionLevel() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().avroCompressionLevel();
    }

    public AvroDataset withAvroCompressionLevel(Integer avroCompressionLevel) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AvroDatasetTypeProperties();
        }
        this.innerTypeProperties().withAvroCompressionLevel(avroCompressionLevel);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
    }
}

