package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 根据租户ID维度藏品查询接口
 *
 * @author auto create
 * @since 1.0, 2025-04-17 17:41:39
 */
public class AnttechNftCustomerBatchqueryModel extends AlipayObject {

	private static final long serialVersionUID = 2714414841844534153L;

	/**
	 * 用户标识
	 */
	@ApiField("id_no")
	private String idNo;

	/**
	 * 用户id类型，参考idType
	 */
	@ApiField("id_type")
	private String idType;

	/**
	 * 用于标记支付宝用户在应用下的唯一标识
	 */
	@ApiField("open_id")
	private String openId;

	/**
	 * 页码
	 */
	@ApiField("page")
	private Long page;

	/**
	 * 分页大小-上限10
	 */
	@ApiField("page_size")
	private Long pageSize;

	/**
	 * 请求唯一ID，用于链路跟踪和问题排查
	 */
	@ApiField("req_msg_id")
	private String reqMsgId;

	public String getIdNo() {
		return this.idNo;
	}
	public void setIdNo(String idNo) {
		this.idNo = idNo;
	}

	public String getIdType() {
		return this.idType;
	}
	public void setIdType(String idType) {
		this.idType = idType;
	}

	public String getOpenId() {
		return this.openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public Long getPage() {
		return this.page;
	}
	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public String getReqMsgId() {
		return this.reqMsgId;
	}
	public void setReqMsgId(String reqMsgId) {
		this.reqMsgId = reqMsgId;
	}

}
