/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redis.lettuce;

import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.ResultData;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.redis.lettuce.LettuceConnectionManager;
import com.alicp.jetcache.redis.lettuce.RedisLettuceCacheConfig;
import com.alicp.jetcache.support.JetCacheExecutor;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import io.lettuce.core.api.sync.RedisStringCommands;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.reactive.RedisClusterReactiveCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class RedisLettuceCache<K, V>
extends AbstractExternalCache<K, V> {
    private RedisLettuceCacheConfig<K, V> config;
    private Function<Object, byte[]> valueEncoder;
    private Function<byte[], Object> valueDecoder;
    private final AbstractRedisClient client;
    private LettuceConnectionManager lettuceConnectionManager;
    private RedisStringCommands<byte[], byte[]> stringCommands;
    private RedisStringAsyncCommands<byte[], byte[]> stringAsyncCommands;
    private RedisKeyAsyncCommands<byte[], byte[]> keyAsyncCommands;

    public RedisLettuceCache(RedisLettuceCacheConfig<K, V> config) {
        super(config);
        this.config = config;
        this.valueEncoder = config.getValueEncoder();
        this.valueDecoder = config.getValueDecoder();
        if (config.getRedisClient() == null) {
            throw new CacheConfigException("RedisClient is required");
        }
        if (config.isExpireAfterAccess()) {
            throw new CacheConfigException("expireAfterAccess is not supported");
        }
        this.client = config.getRedisClient();
        this.lettuceConnectionManager = LettuceConnectionManager.defaultManager();
        this.lettuceConnectionManager.init(this.client, config.getConnection());
        this.stringCommands = (RedisStringCommands)this.lettuceConnectionManager.commands(this.client);
        this.stringAsyncCommands = (RedisStringAsyncCommands)this.lettuceConnectionManager.asyncCommands(this.client);
        this.keyAsyncCommands = (RedisKeyAsyncCommands)this.stringAsyncCommands;
    }

    public <T> T unwrap(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        if (AbstractRedisClient.class.isAssignableFrom(clazz)) {
            return (T)this.client;
        }
        if (RedisClusterCommands.class.isAssignableFrom(clazz)) {
            return (T)this.stringCommands;
        }
        if (RedisClusterAsyncCommands.class.isAssignableFrom(clazz)) {
            return (T)this.stringAsyncCommands;
        }
        if (RedisClusterReactiveCommands.class.isAssignableFrom(clazz)) {
            return (T)this.lettuceConnectionManager.reactiveCommands(this.client);
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    public CacheConfig<K, V> config() {
        return this.config;
    }

    private void setTimeout(CacheResult cr) {
        Duration d = Duration.ofMillis(this.config.getAsyncResultTimeoutInMillis());
        cr.setTimeout(d);
    }

    protected CacheResult do_PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        try {
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            byte[] newKey = this.buildKey(key);
            RedisFuture future = this.stringAsyncCommands.psetex((Object)newKey, timeUnit.toMillis(expireAfterWrite), (Object)this.valueEncoder.apply(holder));
            CacheResult result = new CacheResult(future.handle((rt, ex) -> {
                if (ex != null) {
                    JetCacheExecutor.defaultExecutor().execute(() -> this.logError("PUT", key, (Throwable)ex));
                    return new ResultData(ex);
                }
                if ("OK".equals(rt)) {
                    return new ResultData(CacheResultCode.SUCCESS, null, null);
                }
                return new ResultData(CacheResultCode.FAIL, rt, null);
            }));
            this.setTimeout(result);
            return result;
        }
        catch (Exception ex2) {
            this.logError("PUT", key, ex2);
            return new CacheResult((Throwable)ex2);
        }
    }

    protected CacheResult do_PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        if (map == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        try {
            CompletableFuture<Integer> future = CompletableFuture.completedFuture(0);
            for (Map.Entry<K, V> en : map.entrySet()) {
                CacheValueHolder holder = new CacheValueHolder(en.getValue(), timeUnit.toMillis(expireAfterWrite));
                RedisFuture resp = this.stringAsyncCommands.psetex((Object)this.buildKey(en.getKey()), timeUnit.toMillis(expireAfterWrite), (Object)this.valueEncoder.apply(holder));
                future.thenCombine(resp, (failCount, respStr) -> "OK".equals(respStr) ? failCount : failCount + 1);
            }
            CacheResult result = new CacheResult(future.handle((failCount, ex) -> {
                if (ex != null) {
                    JetCacheExecutor.defaultExecutor().execute(() -> this.logError("PUT_ALL", "map(" + map.size() + ")", (Throwable)ex));
                    return new ResultData(ex);
                }
                if (failCount == 0) {
                    return new ResultData(CacheResultCode.SUCCESS, null, null);
                }
                if (failCount.intValue() == map.size()) {
                    return new ResultData(CacheResultCode.FAIL, null, null);
                }
                return new ResultData(CacheResultCode.PART_SUCCESS, null, null);
            }));
            this.setTimeout(result);
            return result;
        }
        catch (Exception ex2) {
            this.logError("PUT_ALL", "map(" + map.size() + ")", ex2);
            return new CacheResult((Throwable)ex2);
        }
    }

    protected CacheGetResult<V> do_GET(K key) {
        if (key == null) {
            return new CacheGetResult(CacheResultCode.FAIL, "illegal argument", null);
        }
        try {
            byte[] newKey = this.buildKey(key);
            RedisFuture future = this.stringAsyncCommands.get((Object)newKey);
            CacheGetResult result = new CacheGetResult(future.handle((valueBytes, ex) -> {
                if (ex != null) {
                    JetCacheExecutor.defaultExecutor().execute(() -> this.logError("GET", key, (Throwable)ex));
                    return new ResultData(ex);
                }
                if (valueBytes != null) {
                    CacheValueHolder holder = (CacheValueHolder)this.valueDecoder.apply((byte[])valueBytes);
                    if (System.currentTimeMillis() >= holder.getExpireTime()) {
                        return new ResultData(CacheResultCode.EXPIRED, null, null);
                    }
                    return new ResultData(CacheResultCode.SUCCESS, null, (Object)holder);
                }
                return new ResultData(CacheResultCode.NOT_EXISTS, null, null);
            }));
            this.setTimeout((CacheResult)result);
            return result;
        }
        catch (Exception ex2) {
            this.logError("GET", key, ex2);
            return new CacheGetResult((Throwable)ex2);
        }
    }

    protected MultiGetResult<K, V> do_GET_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return new MultiGetResult(CacheResultCode.FAIL, "illegal argument", null);
        }
        try {
            ArrayList<K> keyList = new ArrayList<K>(keys);
            byte[][] newKeys = (byte[][])keyList.stream().map(k -> this.buildKey(k)).toArray(x$0 -> new byte[x$0][]);
            HashMap resultMap = new HashMap();
            if (newKeys.length == 0) {
                return new MultiGetResult(CacheResultCode.SUCCESS, null, resultMap);
            }
            RedisFuture mgetResults = this.stringAsyncCommands.mget((Object[])newKeys);
            MultiGetResult result = new MultiGetResult(mgetResults.handle((list, ex) -> {
                if (ex != null) {
                    JetCacheExecutor.defaultExecutor().execute(() -> this.logError("GET_ALL", "keys(" + keys.size() + ")", (Throwable)ex));
                    return new ResultData(ex);
                }
                for (int i = 0; i < list.size(); ++i) {
                    KeyValue kv = (KeyValue)list.get(i);
                    Object key = keyList.get(i);
                    if (kv != null && kv.hasValue()) {
                        CacheValueHolder holder = (CacheValueHolder)this.valueDecoder.apply((byte[])kv.getValue());
                        if (System.currentTimeMillis() >= holder.getExpireTime()) {
                            resultMap.put(key, CacheGetResult.EXPIRED_WITHOUT_MSG);
                            continue;
                        }
                        CacheGetResult r = new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
                        resultMap.put(key, r);
                        continue;
                    }
                    resultMap.put(key, CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
                }
                return new ResultData(CacheResultCode.SUCCESS, null, (Object)resultMap);
            }));
            this.setTimeout((CacheResult)result);
            return result;
        }
        catch (Exception ex2) {
            this.logError("GET_ALL", "keys(" + keys.size() + ")", ex2);
            return new MultiGetResult((Throwable)ex2);
        }
    }

    protected CacheResult do_REMOVE(K key) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        try {
            RedisFuture future = this.keyAsyncCommands.del((Object[])new byte[][]{this.buildKey(key)});
            CacheResult result = new CacheResult(future.handle((rt, ex) -> {
                if (ex != null) {
                    JetCacheExecutor.defaultExecutor().execute(() -> this.logError("REMOVE", key, (Throwable)ex));
                    return new ResultData(ex);
                }
                if (rt == null) {
                    return new ResultData(CacheResultCode.FAIL, null, null);
                }
                if (rt == 1L) {
                    return new ResultData(CacheResultCode.SUCCESS, null, null);
                }
                if (rt == 0L) {
                    return new ResultData(CacheResultCode.NOT_EXISTS, null, null);
                }
                return new ResultData(CacheResultCode.FAIL, null, null);
            }));
            this.setTimeout(result);
            return result;
        }
        catch (Exception ex2) {
            this.logError("REMOVE", key, ex2);
            return new CacheResult((Throwable)ex2);
        }
    }

    protected CacheResult do_REMOVE_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        try {
            byte[][] newKeys = (byte[][])keys.stream().map(k -> this.buildKey(k)).toArray(len -> new byte[keys.size()][]);
            RedisFuture future = this.keyAsyncCommands.del((Object[])newKeys);
            CacheResult result = new CacheResult(future.handle((v, ex) -> {
                if (ex != null) {
                    JetCacheExecutor.defaultExecutor().execute(() -> this.logError("REMOVE_ALL", "keys(" + keys.size() + ")", (Throwable)ex));
                    return new ResultData(ex);
                }
                return new ResultData(CacheResultCode.SUCCESS, null, null);
            }));
            this.setTimeout(result);
            return result;
        }
        catch (Exception ex2) {
            this.logError("REMOVE_ALL", "keys(" + keys.size() + ")", ex2);
            return new CacheResult((Throwable)ex2);
        }
    }

    protected CacheResult do_PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        try {
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            byte[] newKey = this.buildKey(key);
            RedisFuture future = this.stringAsyncCommands.set((Object)newKey, (Object)this.valueEncoder.apply(holder), SetArgs.Builder.nx().px(timeUnit.toMillis(expireAfterWrite)));
            CacheResult result = new CacheResult(future.handle((rt, ex) -> {
                if (ex != null) {
                    JetCacheExecutor.defaultExecutor().execute(() -> this.logError("PUT_IF_ABSENT", key, (Throwable)ex));
                    return new ResultData(ex);
                }
                if ("OK".equals(rt)) {
                    return new ResultData(CacheResultCode.SUCCESS, null, null);
                }
                if (rt == null) {
                    return new ResultData(CacheResultCode.EXISTS, null, null);
                }
                return new ResultData(CacheResultCode.FAIL, rt, null);
            }));
            this.setTimeout(result);
            return result;
        }
        catch (Exception ex2) {
            this.logError("PUT_IF_ABSENT", key, ex2);
            return new CacheResult((Throwable)ex2);
        }
    }
}

