/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheMonitor;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.anno.support.AbstractLifecycle;
import com.alicp.jetcache.anno.support.CacheMonitorManager;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.event.CachePutAllEvent;
import com.alicp.jetcache.event.CachePutEvent;
import com.alicp.jetcache.event.CacheRemoveAllEvent;
import com.alicp.jetcache.event.CacheRemoveEvent;
import com.alicp.jetcache.support.CacheMessage;
import com.alicp.jetcache.support.CacheMessagePublisher;
import com.alicp.jetcache.support.DefaultCacheMonitor;
import com.alicp.jetcache.support.DefaultMetricsManager;
import com.alicp.jetcache.support.StatInfo;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultCacheMonitorManager
extends AbstractLifecycle
implements CacheMonitorManager {
    private DefaultMetricsManager defaultMetricsManager;
    @Resource
    private GlobalCacheConfig globalCacheConfig;
    @Autowired(required=false)
    private Consumer<StatInfo> metricsCallback;
    @Autowired(required=false)
    private CacheMessagePublisher cacheMessagePublisher;

    @Override
    public void addMonitors(String area, String cacheName, Cache cache) {
        this.addMetricsMonitor(area, cacheName, cache);
        this.addCacheUpdateMonitor(area, cacheName, cache);
    }

    protected void addCacheUpdateMonitor(String area, String cacheName, Cache cache) {
        if (this.cacheMessagePublisher != null) {
            CacheMonitor monitor = event -> {
                if (event instanceof CachePutEvent) {
                    CacheMessage m = new CacheMessage();
                    CachePutEvent e = (CachePutEvent)event;
                    m.setType(1);
                    m.setKeys(new Object[]{e.getKey()});
                    this.cacheMessagePublisher.publish(area, cacheName, m);
                } else if (event instanceof CacheRemoveEvent) {
                    CacheMessage m = new CacheMessage();
                    CacheRemoveEvent e = (CacheRemoveEvent)event;
                    m.setType(3);
                    m.setKeys(new Object[]{e.getKey()});
                    this.cacheMessagePublisher.publish(area, cacheName, m);
                } else if (event instanceof CachePutAllEvent) {
                    CacheMessage m = new CacheMessage();
                    CachePutAllEvent e = (CachePutAllEvent)event;
                    m.setType(2);
                    if (e.getMap() != null) {
                        m.setKeys(e.getMap().keySet().toArray());
                    }
                    this.cacheMessagePublisher.publish(area, cacheName, m);
                } else if (event instanceof CacheRemoveAllEvent) {
                    CacheMessage m = new CacheMessage();
                    CacheRemoveAllEvent e = (CacheRemoveAllEvent)event;
                    m.setType(4);
                    if (e.getKeys() != null) {
                        m.setKeys(e.getKeys().toArray());
                    }
                    this.cacheMessagePublisher.publish(area, cacheName, m);
                }
            };
            cache.config().getMonitors().add(monitor);
        }
    }

    protected void addMetricsMonitor(String area, String cacheName, Cache cache) {
        if (this.defaultMetricsManager != null) {
            MultiLevelCache mc;
            if ((cache = CacheUtil.getAbstractCache((Cache)cache)) instanceof MultiLevelCache && (mc = (MultiLevelCache)cache).caches().length == 2) {
                Cache local = mc.caches()[0];
                Cache remote = mc.caches()[1];
                DefaultCacheMonitor localMonitor = new DefaultCacheMonitor(cacheName + "_local");
                local.config().getMonitors().add(localMonitor);
                DefaultCacheMonitor remoteMonitor = new DefaultCacheMonitor(cacheName + "_remote");
                remote.config().getMonitors().add(remoteMonitor);
                this.defaultMetricsManager.add(new DefaultCacheMonitor[]{localMonitor, remoteMonitor});
            }
            DefaultCacheMonitor monitor = new DefaultCacheMonitor(cacheName);
            cache.config().getMonitors().add(monitor);
            this.defaultMetricsManager.add(new DefaultCacheMonitor[]{monitor});
        }
    }

    @Override
    protected void doInit() {
        this.initMetricsMonitor();
    }

    protected void initMetricsMonitor() {
        if (this.globalCacheConfig.getStatIntervalMinutes() > 0) {
            this.defaultMetricsManager = new DefaultMetricsManager(this.globalCacheConfig.getStatIntervalMinutes(), TimeUnit.MINUTES, this.metricsCallback);
            this.defaultMetricsManager.start();
        }
    }

    @Override
    protected void doShutdown() {
        this.shutdownMetricsMonitor();
    }

    protected void shutdownMetricsMonitor() {
        if (this.defaultMetricsManager != null) {
            this.defaultMetricsManager.stop();
        }
        this.defaultMetricsManager = null;
    }

    public void setGlobalCacheConfig(GlobalCacheConfig globalCacheConfig) {
        this.globalCacheConfig = globalCacheConfig;
    }

    public void setMetricsCallback(Consumer<StatInfo> metricsCallback) {
        this.metricsCallback = metricsCallback;
    }

    public void setCacheMessagePublisher(CacheMessagePublisher cacheMessagePublisher) {
        this.cacheMessagePublisher = cacheMessagePublisher;
    }
}

