/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.MultiLevelCacheBuilder;
import com.alicp.jetcache.anno.CacheConsts;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.anno.method.CacheHandler;
import com.alicp.jetcache.anno.method.CacheInvokeConfig;
import com.alicp.jetcache.anno.method.CacheInvokeContext;
import com.alicp.jetcache.anno.support.CacheInvalidateAnnoConfig;
import com.alicp.jetcache.anno.support.CacheThreadLocal;
import com.alicp.jetcache.anno.support.CacheUpdateAnnoConfig;
import com.alicp.jetcache.anno.support.CachedAnnoConfig;
import com.alicp.jetcache.anno.support.ConfigMap;
import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.embedded.EmbeddedCacheBuilder;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.support.DefaultCacheMonitor;
import com.alicp.jetcache.support.DefaultCacheMonitorManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheContext {
    private static Logger logger = LoggerFactory.getLogger(CacheContext.class);
    private static ThreadLocal<CacheThreadLocal> cacheThreadLocal = new ThreadLocal<CacheThreadLocal>(){

        @Override
        protected CacheThreadLocal initialValue() {
            return new CacheThreadLocal();
        }
    };
    private ConfigProvider configProvider;
    private GlobalCacheConfig globalCacheConfig;
    private DefaultCacheMonitorManager defaultCacheMonitorManager;
    private ConcurrentHashMap<String, Cache> cacheManager;

    public CacheContext(GlobalCacheConfig globalCacheConfig) {
        this.globalCacheConfig = globalCacheConfig;
        this.configProvider = globalCacheConfig.getConfigProvider();
    }

    public synchronized void init() {
        if (this.cacheManager == null) {
            this.cacheManager = new ConcurrentHashMap();
            if (this.globalCacheConfig.getStatIntervalMinutes() > 0) {
                this.defaultCacheMonitorManager = new DefaultCacheMonitorManager(this.globalCacheConfig.getStatIntervalMinutes(), TimeUnit.MINUTES, this.globalCacheConfig.getConfigProvider().statCallback());
                this.defaultCacheMonitorManager.start();
            }
        }
    }

    public synchronized void shutdown() {
        if (this.defaultCacheMonitorManager != null) {
            this.defaultCacheMonitorManager.stop();
        }
        ConcurrentHashMap<String, Cache> m = this.cacheManager;
        this.cacheManager = null;
        m.forEach((k, c) -> c.close());
        this.defaultCacheMonitorManager = null;
    }

    public CacheInvokeContext createCacheInvokeContext(ConfigMap configMap) {
        CacheInvokeContext c = this.newCacheInvokeContext();
        c.setCacheFunction((invokeContext, cacheAnnoConfig) -> {
            Cache cache = cacheAnnoConfig.getCache();
            if (cache == null) {
                if (cacheAnnoConfig instanceof CachedAnnoConfig) {
                    cache = this.createCacheByCachedConfig((CachedAnnoConfig)cacheAnnoConfig, (CacheInvokeContext)invokeContext);
                } else if (cacheAnnoConfig instanceof CacheInvalidateAnnoConfig || cacheAnnoConfig instanceof CacheUpdateAnnoConfig) {
                    CacheInvokeConfig cacheDefineConfig = configMap.getByCacheName(cacheAnnoConfig.getArea(), cacheAnnoConfig.getName());
                    if (cacheDefineConfig == null) {
                        String message = "can't find @Cached definition with area=" + cacheAnnoConfig.getArea() + " name=" + cacheAnnoConfig.getName() + ", specified in " + cacheAnnoConfig.getDefineMethod();
                        CacheConfigException e = new CacheConfigException(message);
                        logger.error("Cache operation aborted because can't find @Cached definition", (Throwable)e);
                        return null;
                    }
                    cache = this.createCacheByCachedConfig(cacheDefineConfig.getCachedAnnoConfig(), (CacheInvokeContext)invokeContext);
                }
                cacheAnnoConfig.setCache(cache);
            }
            return cache;
        });
        return c;
    }

    private Cache createCacheByCachedConfig(CachedAnnoConfig ac, CacheInvokeContext invokeContext) {
        String area = ac.getArea();
        String cacheName = ac.getName();
        if (CacheConsts.isUndefined((String)cacheName)) {
            cacheName = this.configProvider.createCacheNameGenerator(invokeContext.getHiddenPackages()).generateCacheName(invokeContext.getMethod(), invokeContext.getTargetObject());
        }
        Cache cache = this.__createOrGetCache(ac, area, cacheName);
        return cache;
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache("default", cacheName);
    }

    public <K, V> Cache<K, V> getCache(String area, String cacheName) {
        String fullCacheName = area + "_" + cacheName;
        Cache cache = this.cacheManager.get(fullCacheName);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache __createOrGetCache(CachedAnnoConfig cachedAnnoConfig, String area, String cacheName) {
        String fullCacheName = area + "_" + cacheName;
        Cache cache = this.cacheManager.get(fullCacheName);
        if (cache == null) {
            CacheContext cacheContext = this;
            synchronized (cacheContext) {
                cache = this.cacheManager.get(fullCacheName);
                if (cache == null) {
                    cache = this.globalCacheConfig.isAreaInCacheName() ? this.buildCache(cachedAnnoConfig, area, fullCacheName) : this.buildCache(cachedAnnoConfig, area, cacheName);
                    this.cacheManager.put(fullCacheName, cache);
                }
            }
        }
        return cache;
    }

    protected Cache buildCache(CachedAnnoConfig cachedAnnoConfig, String area, String cacheName) {
        Object cache;
        if (cachedAnnoConfig.getCacheType() == CacheType.LOCAL) {
            cache = this.buildLocal(cachedAnnoConfig, area);
        } else if (cachedAnnoConfig.getCacheType() == CacheType.REMOTE) {
            cache = this.buildRemote(cachedAnnoConfig, area, cacheName);
        } else {
            Cache local = this.buildLocal(cachedAnnoConfig, area);
            Cache remote = this.buildRemote(cachedAnnoConfig, area, cacheName);
            if (this.defaultCacheMonitorManager != null) {
                DefaultCacheMonitor localMonitor = new DefaultCacheMonitor(cacheName + "_local");
                local.config().getMonitors().add(localMonitor);
                DefaultCacheMonitor remoteMonitor = new DefaultCacheMonitor(cacheName + "_remote");
                remote.config().getMonitors().add(remoteMonitor);
                this.defaultCacheMonitorManager.add(new DefaultCacheMonitor[]{localMonitor, remoteMonitor});
            }
            boolean useExpireOfSubCache = cachedAnnoConfig.getLocalExpire() > 0L;
            cache = ((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)MultiLevelCacheBuilder.createMultiLevelCacheBuilder().expireAfterWrite(remote.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS)).addCache(new Cache[]{local, remote})).useExpireOfSubCache(useExpireOfSubCache)).buildCache();
        }
        cache.config().setRefreshPolicy(cachedAnnoConfig.getRefreshPolicy());
        cache = new CacheHandler.CacheHandlerRefreshCache((Cache)cache);
        cache.config().setCachePenetrationProtect(this.globalCacheConfig.isPenetrationProtect());
        if (cachedAnnoConfig.getPenetrationProtectConfig() != null) {
            cache.config().setCachePenetrationProtect(cachedAnnoConfig.getPenetrationProtectConfig().isPenetrationProtect());
        }
        if (this.defaultCacheMonitorManager != null) {
            DefaultCacheMonitor monitor = new DefaultCacheMonitor(cacheName);
            cache.config().getMonitors().add(monitor);
            this.defaultCacheMonitorManager.add(new DefaultCacheMonitor[]{monitor});
        }
        return cache;
    }

    protected Cache buildRemote(CachedAnnoConfig cachedAnnoConfig, String area, String cacheName) {
        ExternalCacheBuilder cacheBuilder = (ExternalCacheBuilder)this.globalCacheConfig.getRemoteCacheBuilders().get(area);
        if (cacheBuilder == null) {
            throw new CacheConfigException("no remote cache builder: " + area);
        }
        cacheBuilder = (ExternalCacheBuilder)cacheBuilder.clone();
        if (cachedAnnoConfig.getExpire() > 0L) {
            cacheBuilder.expireAfterWrite(cachedAnnoConfig.getExpire(), cachedAnnoConfig.getTimeUnit());
        }
        if (cacheBuilder.getConfig().getKeyPrefix() != null) {
            cacheBuilder.setKeyPrefix(cacheBuilder.getConfig().getKeyPrefix() + cacheName);
        } else {
            cacheBuilder.setKeyPrefix(cacheName);
        }
        if (!CacheConsts.isUndefined((String)cachedAnnoConfig.getKeyConvertor())) {
            cacheBuilder.setKeyConvertor(this.configProvider.parseKeyConvertor(cachedAnnoConfig.getKeyConvertor()));
        }
        if (!CacheConsts.isUndefined((String)cachedAnnoConfig.getSerialPolicy())) {
            cacheBuilder.setValueEncoder(this.configProvider.parseValueEncoder(cachedAnnoConfig.getSerialPolicy()));
            cacheBuilder.setValueDecoder(this.configProvider.parseValueDecoder(cachedAnnoConfig.getSerialPolicy()));
        }
        cacheBuilder.setCacheNullValue(cachedAnnoConfig.isCacheNullValue());
        return cacheBuilder.buildCache();
    }

    protected Cache buildLocal(CachedAnnoConfig cachedAnnoConfig, String area) {
        EmbeddedCacheBuilder cacheBuilder = (EmbeddedCacheBuilder)this.globalCacheConfig.getLocalCacheBuilders().get(area);
        if (cacheBuilder == null) {
            throw new CacheConfigException("no local cache builder: " + area);
        }
        cacheBuilder = (EmbeddedCacheBuilder)cacheBuilder.clone();
        if (cachedAnnoConfig.getLocalLimit() != Integer.MIN_VALUE) {
            cacheBuilder.setLimit(cachedAnnoConfig.getLocalLimit());
        }
        if (cachedAnnoConfig.getCacheType() == CacheType.BOTH && cachedAnnoConfig.getLocalExpire() > 0L) {
            cacheBuilder.expireAfterWrite(cachedAnnoConfig.getLocalExpire(), cachedAnnoConfig.getTimeUnit());
        } else if (cachedAnnoConfig.getExpire() > 0L) {
            cacheBuilder.expireAfterWrite(cachedAnnoConfig.getExpire(), cachedAnnoConfig.getTimeUnit());
        }
        if (!CacheConsts.isUndefined((String)cachedAnnoConfig.getKeyConvertor())) {
            cacheBuilder.setKeyConvertor(this.configProvider.parseKeyConvertor(cachedAnnoConfig.getKeyConvertor()));
        }
        cacheBuilder.setCacheNullValue(cachedAnnoConfig.isCacheNullValue());
        return cacheBuilder.buildCache();
    }

    protected CacheInvokeContext newCacheInvokeContext() {
        return new CacheInvokeContext();
    }

    public static <T> T enableCache(Supplier<T> callback) {
        CacheThreadLocal var = cacheThreadLocal.get();
        try {
            var.setEnabledCount(var.getEnabledCount() + 1);
            T t = callback.get();
            return t;
        }
        finally {
            var.setEnabledCount(var.getEnabledCount() - 1);
        }
    }

    protected static void enable() {
        CacheThreadLocal var = cacheThreadLocal.get();
        var.setEnabledCount(var.getEnabledCount() + 1);
    }

    protected static void disable() {
        CacheThreadLocal var = cacheThreadLocal.get();
        var.setEnabledCount(var.getEnabledCount() - 1);
    }

    protected static boolean isEnabled() {
        return cacheThreadLocal.get().getEnabledCount() > 0;
    }
}

