/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.sql.ast.ClusteringType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInputOutputFormat;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsCreateTableStatement;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class OdpsCreateTableParser
extends SQLCreateTableParser {
    public OdpsCreateTableParser(String sql) {
        super(new OdpsExprParser(sql, new SQLParserFeature[0]));
    }

    public OdpsCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        SQLColumnDefinition column;
        SQLSelect select;
        OdpsSelectParser selectParser;
        SQLName name;
        HiveInputOutputFormat format;
        OdpsCreateTableStatement stmt = new OdpsCreateTableStatement();
        this.accept(Token.CREATE);
        if (this.lexer.nextIf(Token.OR)) {
            this.accept(Token.REPLACE);
            stmt.config(SQLCreateTableStatement.Feature.OrReplace);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            stmt.setExternal(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            stmt.setComment(this.exprParser.primary());
        }
        if (this.lexer.token() == Token.SEMI || this.lexer.token() == Token.EOF) {
            return stmt;
        }
        while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
                this.parseOptions(stmt);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
                this.lexer.nextToken();
                stmt.setLifeCycle(this.exprParser.expr());
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.STORED)) break;
            this.lexer.nextToken();
            this.accept(Token.AS);
            if (this.lexer.identifierEquals(FnvHash.Constants.INPUTFORMAT)) {
                format = new HiveInputOutputFormat();
                this.lexer.nextToken();
                format.setInput(this.exprParser.primary());
                if (this.lexer.identifierEquals(FnvHash.Constants.OUTPUTFORMAT)) {
                    this.lexer.nextToken();
                    format.setOutput(this.exprParser.primary());
                }
                stmt.setStoredAs(format);
                continue;
            }
            name = this.exprParser.name();
            stmt.setStoredAs(name);
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            name = this.exprParser.name();
            stmt.setLike(name);
        } else if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            selectParser = new OdpsSelectParser(this.exprParser);
            select = selectParser.select();
            stmt.setSelect(select);
        } else if (this.lexer.token() == Token.LPAREN || !stmt.isExternal()) {
            this.accept(Token.LPAREN);
            if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                stmt.addBodyBeforeComment(this.lexer.readAndResetComments());
            }
            while (true) {
                switch (this.lexer.token()) {
                    case IDENTIFIER: 
                    case KEY: 
                    case SEQUENCE: 
                    case USER: 
                    case GROUP: 
                    case INDEX: 
                    case ENABLE: 
                    case DISABLE: 
                    case DESC: 
                    case ALL: 
                    case INTERVAL: 
                    case OPEN: 
                    case PARTITION: 
                    case SCHEMA: 
                    case CONSTRAINT: 
                    case COMMENT: 
                    case VIEW: 
                    case SHOW: 
                    case ORDER: 
                    case LEAVE: 
                    case UNIQUE: 
                    case DEFAULT: 
                    case EXPLAIN: 
                    case CHECK: 
                    case CLOSE: 
                    case IN: 
                    case OUT: 
                    case INOUT: 
                    case LIMIT: 
                    case FULL: 
                    case MINUS: 
                    case VALUES: 
                    case TRIGGER: 
                    case USE: 
                    case LIKE: 
                    case DISTRIBUTE: 
                    case DELETE: 
                    case UPDATE: 
                    case IS: 
                    case LEFT: 
                    case RIGHT: 
                    case REPEAT: 
                    case COMPUTE: 
                    case LOCK: 
                    case TABLE: 
                    case DO: 
                    case WHILE: 
                    case LOOP: 
                    case FOR: 
                    case RLIKE: 
                    case PROCEDURE: 
                    case GRANT: 
                    case EXCEPT: 
                    case CREATE: 
                    case PARTITIONED: 
                    case UNION: 
                    case PRIMARY: 
                    case INNER: 
                    case TO: 
                    case DECLARE: 
                    case REFERENCES: 
                    case FOREIGN: 
                    case ESCAPE: 
                    case BY: 
                    case ALTER: 
                    case SOME: 
                    case ASC: 
                    case NULL: 
                    case CURSOR: 
                    case FETCH: 
                    case OVER: 
                    case DATABASE: 
                    case FUNCTION: {
                        column = this.exprParser.parseColumn(stmt);
                        break;
                    }
                    default: {
                        throw new ParserException("expect identifier. " + this.lexer.info());
                    }
                }
                stmt.addColumn(column);
                if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                    column.addAfterComment(this.lexer.readAndResetComments());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
                if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                column.addAfterComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.RPAREN);
        }
        while (true) {
            SQLSelectOrderByItem item;
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                stmt.setComment(this.exprParser.primary());
                continue;
            }
            if (this.lexer.token() == Token.PARTITIONED) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                this.accept(Token.LPAREN);
                while (true) {
                    switch (this.lexer.token()) {
                        case IDENTIFIER: 
                        case KEY: 
                        case SEQUENCE: 
                        case USER: 
                        case GROUP: 
                        case INDEX: 
                        case INTERVAL: 
                        case PARTITION: 
                        case CHECK: 
                        case TABLE: 
                        case LOOP: 
                        case VARIANT: {
                            break;
                        }
                        default: {
                            throw new ParserException("expect identifier. " + this.lexer.info());
                        }
                    }
                    column = this.exprParser.parseColumn();
                    stmt.addPartitionColumn(column);
                    if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                        column.addAfterComment(this.lexer.readAndResetComments());
                    }
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                    if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                    column.addAfterComment(this.lexer.readAndResetComments());
                }
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.nextIfIdentifier("AUTO")) {
                this.accept(Token.PARTITIONED);
                this.accept(Token.BY);
                this.accept(Token.LPAREN);
                stmt.setAutoPartitionedBy(this.exprParser.aliasedExpr());
                this.accept(Token.RPAREN);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
                this.lexer.nextToken();
                if (!this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) continue;
                stmt.setClusteringType(ClusteringType.Range);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                this.accept(Token.LPAREN);
                while (true) {
                    item = this.exprParser.parseSelectOrderByItem();
                    stmt.addClusteredByItem(item);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
                SQLExternalRecordFormat recordFormat = this.exprParser.parseRowFormat();
                stmt.setRowFormat(recordFormat);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SORTED)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                this.accept(Token.LPAREN);
                while (true) {
                    item = this.exprParser.parseSelectOrderByItem();
                    stmt.addSortedByItem(item);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                continue;
            }
            if (stmt.getClusteringType() != ClusteringType.Range && (stmt.getClusteredBy().size() > 0 || stmt.getSortedBy().size() > 0) && this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("into buckets must be integer. " + this.lexer.info());
                }
                stmt.setBuckets(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
                this.acceptIdentifier("BUCKETS");
                if (this.lexer.token() != Token.INTO) continue;
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("into shards must be integer. " + this.lexer.info());
                }
                stmt.setShards(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
                this.acceptIdentifier("SHARDS");
                continue;
            }
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LITERAL_INT) {
                    stmt.setIntoBuckets(new SQLIntegerExpr(this.lexer.integerValue().intValue()));
                    this.lexer.nextToken();
                    this.acceptIdentifier("BUCKETS");
                    continue;
                }
                throw new ParserException("into shards must be integer. " + this.lexer.info());
            }
            if (this.lexer.token() == Token.AS && stmt.getSelect() == null) {
                this.lexer.nextToken();
                selectParser = new OdpsSelectParser(this.exprParser);
                select = selectParser.select();
                stmt.setSelect(select);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
                this.lexer.nextToken();
                stmt.setLifeCycle(this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.AS) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals(FnvHash.Constants.INPUTFORMAT)) {
                        format = new HiveInputOutputFormat();
                        this.lexer.nextToken();
                        format.setInput(this.exprParser.primary());
                        if (this.lexer.identifierEquals(FnvHash.Constants.OUTPUTFORMAT)) {
                            this.lexer.nextToken();
                            format.setOutput(this.exprParser.primary());
                        }
                        stmt.setStoredAs(format);
                        continue;
                    }
                    SQLName storedAs = this.exprParser.name();
                    stmt.setStoredAs(storedAs);
                    continue;
                }
                this.accept(Token.BY);
                SQLExpr storedBy = this.exprParser.expr();
                stmt.setStoredBy(storedBy);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
                this.lexer.nextToken();
                stmt.setLifeCycle(this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier("SERDEPROPERTIES");
                this.accept(Token.LPAREN);
                this.exprParser.exprList(stmt.getWithSerdeproperties(), stmt);
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
                this.parseOptions(stmt);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
                this.lexer.nextToken();
                SQLExpr location = this.exprParser.expr();
                stmt.setLocation(location);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
                this.parseOptions(stmt);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                this.lexer.nextToken();
                SQLExpr using = this.exprParser.expr();
                stmt.setUsing(using);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) break;
            this.lexer.nextToken();
            stmt.setLifeCycle(this.exprParser.expr());
        }
        return stmt;
    }
}

