/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.starrocks.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.starrocks.ast.statement.StarRocksCreateTableStatement;
import com.alibaba.druid.sql.dialect.starrocks.visitor.StarRocksASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class StarRocksOutputVisitor
extends SQLASTOutputVisitor
implements StarRocksASTVisitor {
    public StarRocksOutputVisitor(Appendable appender) {
        super(appender);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    public StarRocksOutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    public StarRocksOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    @Override
    public boolean visit(StarRocksCreateTableStatement x) {
        SQLExpr partitionBy;
        super.visit(x);
        SQLName model = x.getModelKey();
        if (model != null) {
            String modelName;
            this.println();
            switch (modelName = model.getSimpleName().toLowerCase()) {
                case "duplicate": {
                    this.print0(this.ucase ? "DUPLICATE" : "duplicate");
                    break;
                }
                case "aggregate": {
                    this.print0(this.ucase ? "AGGREGATE" : "aggregate");
                    break;
                }
                case "unique": {
                    this.print0(this.ucase ? "UNIQUE" : "unique");
                    break;
                }
                case "primary": {
                    this.print0(this.ucase ? "PRIMARY" : "primary");
                    break;
                }
            }
            this.print(' ');
            this.print0(this.ucase ? "KEY" : "key");
            if (x.getModelKeyParameters().size() > 0) {
                for (int i = 0; i < x.getModelKeyParameters().size(); ++i) {
                    if (i != 0) {
                        this.println(", ");
                    }
                    x.getModelKeyParameters().get(i).accept(this);
                }
            }
        }
        if ((partitionBy = x.getPartitionBy()) != null) {
            int i;
            int size;
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            partitionBy.accept(this);
            this.println();
            this.print0("(");
            this.println();
            if (x.isLessThan()) {
                Map<SQLExpr, SQLExpr> lessThanMap = x.getLessThanMap();
                Set<SQLExpr> keySet = lessThanMap.keySet();
                size = keySet.size();
                if (size > 0) {
                    i = 0;
                    for (SQLExpr key : keySet) {
                        if (i != 0) {
                            this.println(", ");
                        }
                        SQLObject value = lessThanMap.get(key);
                        this.print0(this.ucase ? "  PARTITION " : "  partition ");
                        key.accept(this);
                        this.print0(this.ucase ? " VALUES LESS THAN " : " values less than ");
                        String s = value.toString();
                        if (s.startsWith("MAXVALUE")) {
                            value.accept(this);
                        } else {
                            this.print0("(");
                            value.accept(this);
                            this.print0(")");
                        }
                        ++i;
                    }
                }
            } else if (x.isFixedRange()) {
                Map<SQLExpr, List<SQLExpr>> fixedRangeMap = x.getFixedRangeMap();
                Set<SQLExpr> keySet = fixedRangeMap.keySet();
                size = keySet.size();
                if (size > 0) {
                    i = 0;
                    for (SQLExpr key : keySet) {
                        List<SQLExpr> valueList = fixedRangeMap.get(key);
                        int listSize = valueList.size();
                        this.print0(this.ucase ? "  PARTITION " : "  partition ");
                        key.accept(this);
                        this.print0(this.ucase ? " VALUES " : " values ");
                        this.print0("[");
                        for (int j = 0; j < listSize; ++j) {
                            SQLExpr sqlExpr = valueList.get(j);
                            String[] split = sqlExpr.toString().split(",");
                            if (split.length <= 1) {
                                this.print0("(");
                                sqlExpr.accept(this);
                                this.print0(")");
                            } else {
                                sqlExpr.accept(this);
                            }
                            if (j == listSize - 1) continue;
                            this.print0(",");
                        }
                        this.print0(")");
                        if (i != size - 1) {
                            this.print0(",");
                            this.println();
                        }
                        ++i;
                    }
                }
            } else if (x.isStartEnd()) {
                if (x.getStart() != null) {
                    this.print0(this.ucase ? "  START " : "  start ");
                    this.print0("(");
                    x.getStart().accept(this);
                    this.print0(")");
                }
                if (x.getEnd() != null) {
                    this.print0(this.ucase ? "  END " : "  end ");
                    this.print0("(");
                    x.getEnd().accept(this);
                    this.print0(")");
                }
                if (x.getEvery() != null) {
                    this.print0(this.ucase ? "  EVERY " : "  every ");
                    this.print0("(");
                    x.getEvery().accept(this);
                    this.print0(")");
                }
            }
            this.println();
            this.print0(")");
        }
        this.println();
        if (x.getDistributedBy() != null) {
            this.print0(this.ucase ? "DISTRIBUTED BY " : "distributed by ");
            x.getDistributedBy().accept(this);
            this.print0(this.ucase ? " BUCKETS " : "buckets ");
            int buckets = x.getBuckets();
            this.print0(String.valueOf(buckets));
        }
        this.println();
        int propertiesSize = x.getPropertiesMap().size();
        int lBracketSize = x.getlBracketPropertiesMap().size();
        if (propertiesSize > 0 || lBracketSize > 0) {
            this.print0(this.ucase ? "PROPERTIES " : "properties ");
            this.print0("(");
            if (propertiesSize > 0) {
                Map<SQLCharExpr, SQLCharExpr> propertiesMap = x.getPropertiesMap();
                Set<SQLCharExpr> keySet = propertiesMap.keySet();
                int i = 0;
                for (SQLCharExpr key : keySet) {
                    this.println();
                    this.print0("  ");
                    this.print0(key.getText());
                    this.print0(" = ");
                    this.print0(propertiesMap.get(key).getText());
                    if (lBracketSize > 0 || i != keySet.size() - 1) {
                        this.print0(",");
                    }
                    ++i;
                }
            }
            if (lBracketSize > 0) {
                Map<SQLCharExpr, SQLCharExpr> lBracketPropertiesMap = x.getlBracketPropertiesMap();
                Set<SQLCharExpr> keySet = lBracketPropertiesMap.keySet();
                int i = 0;
                for (SQLCharExpr key : keySet) {
                    this.println();
                    this.print0("  ");
                    this.print0("[");
                    this.print0(key.getText());
                    this.print0(" = ");
                    this.print0(lBracketPropertiesMap.get(key).getText());
                    if (i != keySet.size() - 1) {
                        this.print0(",");
                    }
                    this.print0("]");
                    ++i;
                }
            }
            this.println();
            this.print0(")");
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        super.visit(x);
        if (x.getAggType() != null) {
            this.print(' ');
            this.print0(this.ucase ? x.getAggType().getText().toUpperCase(Locale.ROOT) : x.getAggType().getText().toLowerCase(Locale.ROOT));
        }
        if (x.getBitmap() != null) {
            this.print(' ');
            this.print0(this.ucase ? "USING " : "using ");
            this.print0(this.ucase ? x.getBitmap().getText().toUpperCase(Locale.ROOT) : x.getBitmap().getText().toLowerCase(Locale.ROOT));
        }
        if (x.getIndexComment() != null) {
            this.print(' ');
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getIndexComment().accept(this);
        }
        return false;
    }
}

