/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.zuul.api.route;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import com.netflix.zuul.context.RequestContext;
import java.util.regex.Pattern;

public class RegexRoutePathMatcher
implements Predicate<RequestContext> {
    private final String pattern;
    private final Pattern regex;

    public RegexRoutePathMatcher(String pattern) {
        AssertUtil.assertNotBlank((String)pattern, (String)"pattern cannot be blank");
        this.pattern = pattern;
        this.regex = Pattern.compile(pattern);
    }

    public boolean test(RequestContext context) {
        String path = context.getRequest().getServletPath();
        return this.regex.matcher(path).matches();
    }

    public String getPattern() {
        return this.pattern;
    }
}

