/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow;

import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.TokenService;
import com.alibaba.csp.sentinel.cluster.flow.ClusterFlowChecker;
import com.alibaba.csp.sentinel.cluster.flow.ClusterParamFlowChecker;
import com.alibaba.csp.sentinel.cluster.flow.ConcurrentClusterFlowChecker;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.spi.Spi;
import java.util.Collection;

@Spi(isDefault=true)
public class DefaultTokenService
implements TokenService {
    public TokenResult requestToken(Long ruleId, int acquireCount, boolean prioritized) {
        if (this.notValidRequest(ruleId, acquireCount)) {
            return this.badRequest();
        }
        FlowRule rule = ClusterFlowRuleManager.getFlowRuleById(ruleId);
        if (rule == null) {
            return new TokenResult(Integer.valueOf(3));
        }
        return ClusterFlowChecker.acquireClusterToken(rule, acquireCount, prioritized);
    }

    public TokenResult requestParamToken(Long ruleId, int acquireCount, Collection<Object> params) {
        if (this.notValidRequest(ruleId, acquireCount) || params == null || params.isEmpty()) {
            return this.badRequest();
        }
        ParamFlowRule rule = ClusterParamFlowRuleManager.getParamRuleById(ruleId);
        if (rule == null) {
            return new TokenResult(Integer.valueOf(3));
        }
        return ClusterParamFlowChecker.acquireClusterToken(rule, acquireCount, params);
    }

    public TokenResult requestConcurrentToken(String clientAddress, Long ruleId, int acquireCount) {
        if (this.notValidRequest(clientAddress, ruleId, acquireCount)) {
            return this.badRequest();
        }
        FlowRule rule = ClusterFlowRuleManager.getFlowRuleById(ruleId);
        if (rule == null) {
            return new TokenResult(Integer.valueOf(3));
        }
        return ConcurrentClusterFlowChecker.acquireConcurrentToken(clientAddress, rule, acquireCount);
    }

    public void releaseConcurrentToken(Long tokenId) {
        if (tokenId == null) {
            return;
        }
        ConcurrentClusterFlowChecker.releaseConcurrentToken(tokenId);
    }

    private boolean notValidRequest(Long id, int count) {
        return id == null || id <= 0L || count <= 0;
    }

    private boolean notValidRequest(String address, Long id, int count) {
        return address == null || "".equals(address) || id == null || id <= 0L || count <= 0;
    }

    private TokenResult badRequest() {
        return new TokenResult(Integer.valueOf(-4));
    }
}

