/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.rule;

import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayParamFlowItem;
import java.util.Objects;

public class GatewayFlowRule {
    private String resource;
    private int resourceMode = 0;
    private int grade = 1;
    private double count;
    private long intervalSec = 1L;
    private int controlBehavior = 0;
    private int burst;
    private int maxQueueingTimeoutMs = 500;
    private GatewayParamFlowItem paramItem;

    public GatewayFlowRule() {
    }

    public GatewayFlowRule(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public GatewayFlowRule setResource(String resource) {
        this.resource = resource;
        return this;
    }

    public int getResourceMode() {
        return this.resourceMode;
    }

    public GatewayFlowRule setResourceMode(int resourceMode) {
        this.resourceMode = resourceMode;
        return this;
    }

    public int getGrade() {
        return this.grade;
    }

    public GatewayFlowRule setGrade(int grade) {
        this.grade = grade;
        return this;
    }

    public int getControlBehavior() {
        return this.controlBehavior;
    }

    public GatewayFlowRule setControlBehavior(int controlBehavior) {
        this.controlBehavior = controlBehavior;
        return this;
    }

    public double getCount() {
        return this.count;
    }

    public GatewayFlowRule setCount(double count) {
        this.count = count;
        return this;
    }

    public long getIntervalSec() {
        return this.intervalSec;
    }

    public GatewayFlowRule setIntervalSec(long intervalSec) {
        this.intervalSec = intervalSec;
        return this;
    }

    public int getBurst() {
        return this.burst;
    }

    public GatewayFlowRule setBurst(int burst) {
        this.burst = burst;
        return this;
    }

    public GatewayParamFlowItem getParamItem() {
        return this.paramItem;
    }

    public GatewayFlowRule setParamItem(GatewayParamFlowItem paramItem) {
        this.paramItem = paramItem;
        return this;
    }

    public int getMaxQueueingTimeoutMs() {
        return this.maxQueueingTimeoutMs;
    }

    public GatewayFlowRule setMaxQueueingTimeoutMs(int maxQueueingTimeoutMs) {
        this.maxQueueingTimeoutMs = maxQueueingTimeoutMs;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayFlowRule rule = (GatewayFlowRule)o;
        if (this.resourceMode != rule.resourceMode) {
            return false;
        }
        if (this.grade != rule.grade) {
            return false;
        }
        if (Double.compare(rule.count, this.count) != 0) {
            return false;
        }
        if (this.intervalSec != rule.intervalSec) {
            return false;
        }
        if (this.controlBehavior != rule.controlBehavior) {
            return false;
        }
        if (this.burst != rule.burst) {
            return false;
        }
        if (this.maxQueueingTimeoutMs != rule.maxQueueingTimeoutMs) {
            return false;
        }
        if (!Objects.equals(this.resource, rule.resource)) {
            return false;
        }
        return Objects.equals(this.paramItem, rule.paramItem);
    }

    public int hashCode() {
        int result = this.resource != null ? this.resource.hashCode() : 0;
        result = 31 * result + this.resourceMode;
        result = 31 * result + this.grade;
        long temp = Double.doubleToLongBits(this.count);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.intervalSec ^ this.intervalSec >>> 32);
        result = 31 * result + this.controlBehavior;
        result = 31 * result + this.burst;
        result = 31 * result + this.maxQueueingTimeoutMs;
        result = 31 * result + (this.paramItem != null ? this.paramItem.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GatewayFlowRule{resource='" + this.resource + '\'' + ", resourceMode=" + this.resourceMode + ", grade=" + this.grade + ", count=" + this.count + ", intervalSec=" + this.intervalSec + ", controlBehavior=" + this.controlBehavior + ", burst=" + this.burst + ", maxQueueingTimeoutMs=" + this.maxQueueingTimeoutMs + ", paramItem=" + this.paramItem + '}';
    }
}

