/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel;

import com.alibaba.cloud.sentinel.SentinelProperties;
import com.alibaba.cloud.sentinel.SentinelWebMvcConfigurer;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.SentinelWebInterceptor;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.DefaultBlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.UrlCleaner;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.config.SentinelWebMvcConfig;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(name={"spring.cloud.sentinel.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={SentinelWebInterceptor.class})
@EnableConfigurationProperties(value={SentinelProperties.class})
public class SentinelWebAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(SentinelWebAutoConfiguration.class);
    @Autowired
    private SentinelProperties properties;
    @Autowired
    private Optional<UrlCleaner> urlCleanerOptional;
    @Autowired
    private Optional<BlockExceptionHandler> blockExceptionHandlerOptional;
    @Autowired
    private Optional<RequestOriginParser> requestOriginParserOptional;

    @Bean
    @ConditionalOnProperty(name={"spring.cloud.sentinel.filter.enabled"}, matchIfMissing=true)
    public SentinelWebInterceptor sentinelWebInterceptor(SentinelWebMvcConfig sentinelWebMvcConfig) {
        return new SentinelWebInterceptor(sentinelWebMvcConfig);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.cloud.sentinel.filter.enabled"}, matchIfMissing=true)
    public SentinelWebMvcConfig sentinelWebMvcConfig() {
        SentinelWebMvcConfig sentinelWebMvcConfig = new SentinelWebMvcConfig();
        sentinelWebMvcConfig.setHttpMethodSpecify(this.properties.getHttpMethodSpecify().booleanValue());
        sentinelWebMvcConfig.setWebContextUnify(this.properties.getWebContextUnify().booleanValue());
        if (this.blockExceptionHandlerOptional.isPresent()) {
            this.blockExceptionHandlerOptional.ifPresent(arg_0 -> ((SentinelWebMvcConfig)sentinelWebMvcConfig).setBlockExceptionHandler(arg_0));
        } else if (StringUtils.hasText((String)this.properties.getBlockPage())) {
            sentinelWebMvcConfig.setBlockExceptionHandler((request, response, e) -> response.sendRedirect(this.properties.getBlockPage()));
        } else {
            sentinelWebMvcConfig.setBlockExceptionHandler((BlockExceptionHandler)new DefaultBlockExceptionHandler());
        }
        this.urlCleanerOptional.ifPresent(arg_0 -> ((SentinelWebMvcConfig)sentinelWebMvcConfig).setUrlCleaner(arg_0));
        this.requestOriginParserOptional.ifPresent(arg_0 -> ((SentinelWebMvcConfig)sentinelWebMvcConfig).setOriginParser(arg_0));
        return sentinelWebMvcConfig;
    }

    @Bean
    @ConditionalOnProperty(name={"spring.cloud.sentinel.filter.enabled"}, matchIfMissing=true)
    public SentinelWebMvcConfigurer sentinelWebMvcConfigurer() {
        return new SentinelWebMvcConfigurer();
    }
}

