/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.utils;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public final class PropertySourcesUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private PropertySourcesUtils() {
    }

    public static Map<String, Object> getSubProperties(Iterable<PropertySource<?>> propertySources, String prefix) {
        MutablePropertySources mutablePropertySources = new MutablePropertySources();
        for (PropertySource<?> source : propertySources) {
            mutablePropertySources.addLast(source);
        }
        return PropertySourcesUtils.getSubProperties((PropertySources)mutablePropertySources, prefix);
    }

    public static Map<String, Object> getSubProperties(ConfigurableEnvironment environment, String prefix) {
        return PropertySourcesUtils.getSubProperties((PropertySources)environment.getPropertySources(), (PropertyResolver)environment, prefix);
    }

    public static String normalizePrefix(String prefix) {
        return prefix.endsWith(".") ? prefix : prefix + ".";
    }

    public static Map<String, Object> getSubProperties(PropertySources propertySources, String prefix) {
        return PropertySourcesUtils.getSubProperties(propertySources, (PropertyResolver)new PropertySourcesPropertyResolver(propertySources), prefix);
    }

    public static Map<String, Object> getSubProperties(PropertySources propertySources, PropertyResolver propertyResolver, String prefix) {
        LinkedHashMap<String, Object> subProperties = new LinkedHashMap<String, Object>();
        String normalizedPrefix = PropertySourcesUtils.normalizePrefix(prefix);
        for (PropertySource source : propertySources) {
            for (String name : PropertySourcesUtils.getPropertyNames(source)) {
                String subName;
                if (subProperties.containsKey(name) || !name.startsWith(normalizedPrefix) || subProperties.containsKey(subName = name.substring(normalizedPrefix.length()))) continue;
                Object value = source.getProperty(name);
                if (value instanceof String) {
                    value = propertyResolver.resolvePlaceholders((String)value);
                }
                subProperties.put(subName, value);
            }
        }
        return Collections.unmodifiableMap(subProperties);
    }

    public static String[] getPropertyNames(PropertySource propertySource) {
        String[] propertyNames;
        String[] stringArray = propertyNames = propertySource instanceof EnumerablePropertySource ? ((EnumerablePropertySource)propertySource).getPropertyNames() : null;
        if (propertyNames == null) {
            propertyNames = EMPTY_STRING_ARRAY;
        }
        return propertyNames;
    }
}

