/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.discovery.actuate.health;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.spring.factory.CacheableEventPublishingNacosServiceFactory;
import com.alibaba.nacos.spring.metadata.NacosServiceMetaData;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.context.ApplicationContext;

public class NacosDiscoveryHealthIndicator
extends AbstractHealthIndicator {
    @Autowired
    private ApplicationContext applicationContext;
    private static final String UP_STATUS = "up";

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.up();
        CacheableEventPublishingNacosServiceFactory cacheableEventPublishingNacosServiceFactory = (CacheableEventPublishingNacosServiceFactory)this.applicationContext.getBean("nacosServiceFactory", CacheableEventPublishingNacosServiceFactory.class);
        for (NamingService namingService : cacheableEventPublishingNacosServiceFactory.getNamingServices()) {
            if (namingService instanceof NacosServiceMetaData) {
                NacosServiceMetaData nacosServiceMetaData = (NacosServiceMetaData)namingService;
                Properties properties = nacosServiceMetaData.getProperties();
                builder.withDetail(JSON.toJSONString((Object)properties), (Object)namingService.getServerStatus());
            }
            if (namingService.getServerStatus().toLowerCase().equals(UP_STATUS)) continue;
            builder.down();
        }
    }
}

