/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.discovery.actuate.endpoint;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;

@Endpoint(id="nacos-discovery")
public class NacosDiscoveryEndpoint {
    @Autowired
    private ApplicationContext applicationContext;
    private static final Integer PAGE_SIZE = 100;

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("nacosDiscoveryGlobalProperties", this.applicationContext.getBean("globalNacosProperties$discovery"));
        NacosServiceFactory nacosServiceFactory = (NacosServiceFactory)this.applicationContext.getBean("nacosServiceFactory", NacosServiceFactory.class);
        JSONArray array = new JSONArray();
        for (NamingService namingService : nacosServiceFactory.getNamingServices()) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("servicesOfServer", (Object)namingService.getServicesOfServer(0, PAGE_SIZE.intValue()));
                jsonObject.put("subscribeServices", (Object)namingService.getSubscribeServices());
                array.add((Object)jsonObject);
            }
            catch (NacosException e) {
                jsonObject.put("serverStatus", (Object)(namingService.getServerStatus() + ": " + e.getErrCode() + "|" + e.getErrMsg()));
            }
        }
        result.put("namingServersStatus", array);
        return result;
    }
}

