/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.kit;

import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.CronUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.support.cache.ResidentTaskCache;
import com.aizuda.snailjob.server.service.dto.CalculateNextTriggerAtDTO;
import java.util.Objects;
import java.util.Optional;

public final class JobKit {
    public static Integer isResident(Integer triggerType, String triggerInterval) {
        if (Objects.equals(triggerType, SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return StatusEnum.NO.getStatus();
        }
        if (Objects.equals(triggerType, WaitStrategies.WaitStrategyEnum.FIXED.getType())) {
            if (Integer.parseInt(triggerInterval) < 10) {
                return StatusEnum.YES.getStatus();
            }
        } else if (Objects.equals(triggerType, WaitStrategies.WaitStrategyEnum.CRON.getType())) {
            if (CronUtils.getExecuteInterval((String)triggerInterval) < 10000L) {
                return StatusEnum.YES.getStatus();
            }
        } else {
            if (Objects.equals(triggerType, WaitStrategies.WaitStrategyEnum.POINT_IN_TIME.getType())) {
                return StatusEnum.NO.getStatus();
            }
            throw new SnailJobServerException("Unknown trigger type");
        }
        return StatusEnum.NO.getStatus();
    }

    public static Long calculateNextTriggerAt(CalculateNextTriggerAtDTO triggerAtDTO) {
        Integer triggerType = triggerAtDTO.getTriggerType();
        String triggerInterval = triggerAtDTO.getTriggerInterval();
        Long nextTriggerAt = 0L;
        if (Objects.equals(triggerAtDTO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            nextTriggerAt = 0L;
        } else if (Objects.equals(triggerAtDTO.getOldResident(), StatusEnum.NO.getStatus()) && Objects.equals(triggerAtDTO.getNewResident(), StatusEnum.NO.getStatus())) {
            nextTriggerAt = JobKit.calculateNextTriggerAt(triggerType, triggerInterval, DateUtils.toNowMilli());
        } else if (Objects.equals(triggerAtDTO.getOldResident(), StatusEnum.YES.getStatus()) && Objects.equals(triggerAtDTO.getNewResident(), StatusEnum.NO.getStatus())) {
            long time = Optional.ofNullable(ResidentTaskCache.get((Long)triggerAtDTO.getId())).orElse(DateUtils.toNowMilli());
            nextTriggerAt = JobKit.calculateNextTriggerAt(triggerType, triggerInterval, time);
        } else if (Objects.equals(triggerAtDTO.getOldResident(), StatusEnum.NO.getStatus()) && Objects.equals(triggerAtDTO.getNewResident(), StatusEnum.YES.getStatus())) {
            nextTriggerAt = DateUtils.toNowMilli();
        }
        return nextTriggerAt;
    }

    public static Long calculateNextTriggerAt(Integer triggerType, String triggerInterval, Long time) {
        if (Objects.equals(triggerType, SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return 0L;
        }
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)triggerType);
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(triggerInterval);
        waitStrategyContext.setNextTriggerAt(time.longValue());
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }
}

